/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.VUtil;

public class DelReviewMgrImpl
extends Manageable
implements DelReviewMgr,
Serializable {
    private static final String CLS_NM = DelReviewMgrImpl.class.getName();
    private UserP userP = new UserP();
    private OrgUnitP ouP = new OrgUnitP();
    private AdminRoleP admRP = new AdminRoleP();
    private PermP permP = new PermP();

    @Override
    @AdminPermissionOperation
    public AdminRole readRole(AdminRole role) throws SecurityException {
        String methodName = "readRole";
        this.assertContext(CLS_NM, methodName, role, 9007);
        this.checkAccess(CLS_NM, methodName);
        return this.admRP.read(role);
    }

    @Override
    @AdminPermissionOperation
    public List<AdminRole> findRoles(String searchVal) throws SecurityException {
        String methodName = "findRoles";
        VUtil.assertNotNull(searchVal, 9005, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        AdminRole adminRole = new AdminRole(searchVal);
        adminRole.setContextId(this.contextId);
        return this.admRP.search(adminRole);
    }

    @Override
    @AdminPermissionOperation
    public List<UserAdminRole> assignedRoles(User user) throws SecurityException {
        String methodName = "assignedRoles";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        User ue = this.userP.read(user, true);
        return ue.getAdminRoles();
    }

    @Override
    @AdminPermissionOperation
    public List<User> assignedUsers(AdminRole role) throws SecurityException {
        String methodName = "assignedUsers";
        this.assertContext(CLS_NM, methodName, role, 9007);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.getAssignedUsers(role);
    }

    @Override
    @AdminPermissionOperation(operationName="readOU")
    public OrgUnit read(OrgUnit entity) throws SecurityException {
        String methodName = "readOU";
        this.assertContext(CLS_NM, methodName, entity, 8001);
        this.checkAccess(CLS_NM, methodName);
        return this.ouP.read(entity);
    }

    @Override
    @AdminPermissionOperation(operationName="searchOU")
    public List<OrgUnit> search(OrgUnit.Type type, String searchVal) throws SecurityException {
        String methodName = "searchOU";
        VUtil.assertNotNull((Object)type, 8002, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        OrgUnit orgUnit = new OrgUnit(searchVal);
        orgUnit.setType(type);
        orgUnit.setContextId(this.contextId);
        return this.ouP.search(orgUnit);
    }

    @Override
    public List<Permission> rolePermissions(AdminRole role) throws SecurityException {
        return this.rolePermissions(role, false);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> rolePermissions(AdminRole role, boolean noInheritance) throws SecurityException {
        String methodName = "rolePermissions";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.search(role, noInheritance);
    }
}

