/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerStatement;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParsedSQLCacheItem;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatementColumnEncryptionSetting;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamInfo;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerStatement
implements ISQLServerStatement {
    private static final long serialVersionUID = -4421134713913331507L;
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    private boolean isResponseBufferingAdaptive = false;
    private boolean wasResponseBufferingSet = false;
    static final String identityQuery = " select SCOPE_IDENTITY() AS GENERATED_KEYS";
    static final String WINDOWS_KEY_STORE_NAME = "MSSQL_CERTIFICATE_STORE";
    String procedureName;
    private int serverCursorId;
    private int serverCursorRowCount;
    boolean stmtPoolable;
    private TDSReader tdsReader;
    Parameter[] inOutParam;
    final SQLServerConnection connection;
    int queryTimeout;
    int cancelQueryTimeoutSeconds;
    boolean isCloseOnCompletion = false;
    private volatile TDSCommand currentCommand = null;
    private TDSCommand lastStmtExecCmd = null;
    static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Statement");
    private final String loggingClassName;
    private final String traceID;
    protected SQLServerStatementColumnEncryptionSetting stmtColumnEncriptionSetting = SQLServerStatementColumnEncryptionSetting.UseConnectionSetting;
    private ExecuteProperties execProps;
    boolean moreResults = false;
    SQLServerResultSet resultSet;
    int resultSetCount = 0;
    static final int EXECUTE_NOT_SET = 0;
    static final int EXECUTE_QUERY = 1;
    static final int EXECUTE_UPDATE = 2;
    static final int EXECUTE = 3;
    static final int EXECUTE_BATCH = 4;
    static final int EXECUTE_QUERY_INTERNAL = 5;
    int executeMethod = 0;
    long updateCount = -1L;
    boolean escapeProcessing;
    int maxRows = 0;
    int maxFieldSize = 0;
    int resultSetConcurrency;
    int appResultSetType;
    int resultSetType;
    boolean executedSqlDirectly = false;
    boolean expectCursorOutParams;
    String cursorName;
    int nFetchSize;
    int defaultFetchSize;
    int nFetchDirection;
    boolean bIsClosed;
    boolean bRequestedGeneratedKeys;
    private ResultSet autoGeneratedKeys;
    private final ArrayList<String> batchStatementBuffer = new ArrayList();
    private static final Logger stmtlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerStatement");
    private static final AtomicInteger lastStatementID = new AtomicInteger(0);
    Vector<SQLWarning> sqlWarnings;
    boolean isInternalEncryptionQuery;
    Map<String, SQLServerColumnEncryptionKeyStoreProvider> statementColumnEncryptionKeyStoreProviders = new HashMap<String, SQLServerColumnEncryptionKeyStoreProvider>();

    final boolean getIsResponseBufferingAdaptive() {
        return this.isResponseBufferingAdaptive;
    }

    final boolean wasResponseBufferingSet() {
        return this.wasResponseBufferingSet;
    }

    final int getServerCursorId() {
        return this.serverCursorId;
    }

    final int getServerCursorRowCount() {
        return this.serverCursorRowCount;
    }

    final TDSReader resultsReader() {
        return this.tdsReader;
    }

    final boolean wasExecuted() {
        return null != this.tdsReader;
    }

    final void discardLastExecutionResults() {
        if (null != this.lastStmtExecCmd && !this.bIsClosed) {
            this.lastStmtExecCmd.close();
            this.lastStmtExecCmd = null;
        }
        this.clearLastResult();
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    protected SQLServerStatementColumnEncryptionSetting getStmtColumnEncriptionSetting() {
        return this.stmtColumnEncriptionSetting;
    }

    final ExecuteProperties getExecProps() {
        return this.execProps;
    }

    final void executeStatement(TDSCommand newStmtCmd) throws SQLServerException, SQLTimeoutException {
        this.discardLastExecutionResults();
        this.checkClosed();
        this.execProps = new ExecuteProperties(this);
        try {
            this.executeCommand(newStmtCmd);
        }
        catch (SQLServerException e) {
            if (e.getDriverErrorCode() == 9) {
                throw new SQLTimeoutException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e.getCause());
            }
            throw e;
        }
        finally {
            if (newStmtCmd.wasExecuted()) {
                this.lastStmtExecCmd = newStmtCmd;
            }
        }
    }

    final void executeCommand(TDSCommand newCommand) throws SQLServerException {
        this.currentCommand = newCommand;
        this.connection.executeCommand(newCommand);
    }

    synchronized void incrResultSetCount() {
        ++this.resultSetCount;
    }

    synchronized void decrResultSetCount() {
        --this.resultSetCount;
        assert (this.resultSetCount >= 0);
        if (this.isCloseOnCompletion && (4 != this.executeMethod || !this.moreResults) && this.resultSetCount == 0) {
            this.closeInternal();
        }
    }

    final int getSQLResultSetType() {
        return this.resultSetType;
    }

    final int getCursorType() {
        return this.getResultSetScrollOpt() & 0xFFFFEFFF;
    }

    final boolean isCursorable(int executeMethod) {
        return this.resultSetType != 2003 && (3 == executeMethod || 1 == executeMethod);
    }

    public String toString() {
        return this.traceID;
    }

    String getClassNameInternal() {
        return "SQLServerStatement";
    }

    private static int nextStatementID() {
        return lastStatementID.incrementAndGet();
    }

    SQLServerStatement(SQLServerConnection con, int nType, int nConcur, SQLServerStatementColumnEncryptionSetting stmtColEncSetting) throws SQLServerException {
        String selectMethod;
        int statementID = SQLServerStatement.nextStatementID();
        String classN = this.getClassNameInternal();
        this.traceID = classN + ":" + statementID;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc." + classN + ":" + statementID;
        this.stmtPoolable = false;
        this.connection = con;
        this.bIsClosed = false;
        if (1003 != nType && 1005 != nType && 1004 != nType && 2003 != nType && 2004 != nType && 1006 != nType && 1005 != nType && 1004 != nType) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursor"), null, true);
        }
        if (1007 != nConcur && 1008 != nConcur && 1009 != nConcur && 1008 != nConcur && 1010 != nConcur) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedConcurrency"), null, true);
        }
        if (null == stmtColEncSetting) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedStmtColEncSetting"), null, true);
        }
        this.stmtColumnEncriptionSetting = stmtColEncSetting;
        this.resultSetConcurrency = nConcur;
        this.appResultSetType = nType;
        this.resultSetType = 1003 == nType ? (1007 == nConcur ? (null == (selectMethod = con.getSelectMethod()) || !"cursor".equals(selectMethod) ? 2003 : 2004) : 2004) : (1004 == nType ? 1004 : (1005 == nType ? 1005 : nType));
        this.nFetchDirection = 2003 == this.resultSetType || 2004 == this.resultSetType ? 1000 : 1002;
        this.defaultFetchSize = this.nFetchSize = 1009 == this.resultSetConcurrency ? 8 : 128;
        if (1007 != nConcur && (2003 == this.resultSetType || 1004 == this.resultSetType)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_unsupportedCursorAndConcurrency"), null, true);
        }
        this.setResponseBuffering(this.connection.getResponseBuffering());
        this.setDefaultQueryTimeout();
        this.setDefaultQueryCancelTimeout();
        if (stmtlogger.isLoggable(Level.FINER)) {
            stmtlogger.finer("Properties for " + this.toString() + ": Result type:" + this.appResultSetType + " (" + this.resultSetType + ") Concurrency:" + this.resultSetConcurrency + " Fetchsize:" + this.nFetchSize + " bIsClosed:" + this.bIsClosed + " useLastUpdateCount:" + this.connection.useLastUpdateCount());
        }
        if (stmtlogger.isLoggable(Level.FINE)) {
            stmtlogger.fine(this.toString() + " created by (" + this.connection.toString() + ")");
        }
    }

    private void setDefaultQueryCancelTimeout() {
        int cancelQueryTimeoutSeconds = this.connection.getCancelQueryTimeoutSeconds();
        if (cancelQueryTimeoutSeconds > 0) {
            this.cancelQueryTimeoutSeconds = cancelQueryTimeoutSeconds;
        }
    }

    private void setDefaultQueryTimeout() {
        int queryTimeoutSeconds = this.connection.getQueryTimeoutSeconds();
        if (queryTimeoutSeconds > 0) {
            this.queryTimeout = queryTimeoutSeconds;
        }
    }

    final Logger getStatementLogger() {
        return stmtlogger;
    }

    void closeInternal() {
        assert (!this.bIsClosed);
        this.discardLastExecutionResults();
        this.bIsClosed = true;
        this.autoGeneratedKeys = null;
        this.sqlWarnings = null;
        this.inOutParam = null;
        this.connection.removeOpenStatement(this);
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "close");
        if (!this.bIsClosed) {
            this.closeInternal();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "closeOnCompletion");
        this.checkClosed();
        this.isCloseOnCompletion = true;
        loggerExternal.exiting(this.getClassNameLogging(), "closeOnCompletion");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery", sql);
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, sql, 1, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeQuery", this.resultSet);
        return this.resultSet;
    }

    final SQLServerResultSet executeQueryInternal(String sql) throws SQLServerException, SQLTimeoutException {
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, sql, 5, 2));
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", sql);
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, sql, 2, 2));
        if (this.updateCount < Integer.MIN_VALUE || this.updateCount > Integer.MAX_VALUE) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_updateCountOutofRange"), null, true);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", this.updateCount);
        return (int)this.updateCount;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeLargeUpdate", sql);
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, sql, 2, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeUpdate", this.updateCount);
        return this.updateCount;
    }

    @Override
    public boolean execute(String sql) throws SQLServerException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "execute", sql);
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.executeStatement(new StmtExecCmd(this, sql, 3, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    private String ensureSQLSyntax(String sql) throws SQLServerException {
        if (sql.indexOf(123) >= 0) {
            SQLServerConnection.CityHash128Key cacheKey = new SQLServerConnection.CityHash128Key(sql);
            ParsedSQLCacheItem cacheItem = SQLServerConnection.getCachedParsedSQL(cacheKey);
            if (null == cacheItem) {
                cacheItem = SQLServerConnection.parseAndCacheSQL(cacheKey, sql);
            }
            this.procedureName = cacheItem.procedureName;
            return cacheItem.processedSQL;
        }
        return sql;
    }

    void startResults() {
        this.moreResults = true;
    }

    final void setMaxRowsAndMaxFieldSize() throws SQLServerException {
        if (1 == this.executeMethod || 3 == this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        } else {
            assert (2 == this.executeMethod || 4 == this.executeMethod || 5 == this.executeMethod);
            this.connection.setMaxRows(0);
        }
    }

    final void doExecuteStatement(StmtExecCmd execCmd) throws SQLServerException {
        this.resetForReexecute();
        this.executeMethod = execCmd.executeMethod;
        String sql = this.ensureSQLSyntax(execCmd.sql);
        if (!this.isInternalEncryptionQuery && this.connection.isAEv2()) {
            execCmd.enclaveCEKs = this.connection.initEnclaveParameters(this, sql, null, null, null);
        }
        this.setMaxRowsAndMaxFieldSize();
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        if (this.isCursorable(this.executeMethod) && this.isSelect(sql)) {
            if (stmtlogger.isLoggable(Level.FINE)) {
                stmtlogger.fine(this.toString() + " Executing server side cursor " + sql);
            }
            this.doExecuteCursored(execCmd, sql);
        } else {
            this.executedSqlDirectly = true;
            this.expectCursorOutParams = false;
            TDSWriter tdsWriter = execCmd.startRequest((byte)1);
            tdsWriter.sendEnclavePackage(sql, execCmd.enclaveCEKs);
            tdsWriter.writeString(sql);
            if (1 == execCmd.autoGeneratedKeys && (2 == this.executeMethod || 3 == this.executeMethod) && sql.trim().toUpperCase().startsWith("INSERT")) {
                tdsWriter.writeString(identityQuery);
            }
            if (stmtlogger.isLoggable(Level.FINE)) {
                stmtlogger.fine(this.toString() + " Executing (not server cursor) " + sql);
            }
            this.ensureExecuteResultsReader(execCmd.startResponse(this.isResponseBufferingAdaptive));
            this.startResults();
            this.getNextResult(true);
        }
        if (null == this.resultSet) {
            if (1 == this.executeMethod) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
            }
        } else if (2 == this.executeMethod || 4 == this.executeMethod) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    private void doExecuteStatementBatch(StmtBatchExecCmd execCmd) throws SQLServerException {
        this.resetForReexecute();
        this.connection.setMaxRows(0);
        String batchStatementString = String.join((CharSequence)";", this.batchStatementBuffer);
        if (this.connection.isAEv2()) {
            execCmd.enclaveCEKs = this.connection.initEnclaveParameters(this, batchStatementString, null, null, null);
        }
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.executeMethod = 4;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        TDSWriter tdsWriter = execCmd.startRequest((byte)1);
        tdsWriter.sendEnclavePackage(batchStatementString, execCmd.enclaveCEKs);
        tdsWriter.writeString(batchStatementString);
        this.ensureExecuteResultsReader(execCmd.startResponse(this.isResponseBufferingAdaptive));
        this.startResults();
        this.getNextResult(true);
        if (null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    final void resetForReexecute() throws SQLServerException {
        this.ensureExecuteResultsReader(null);
        this.autoGeneratedKeys = null;
        this.updateCount = -1L;
        this.sqlWarnings = null;
        this.executedSqlDirectly = false;
        this.startResults();
    }

    final boolean isSelect(String sql) throws SQLServerException {
        this.checkClosed();
        String temp = sql.trim();
        if (null == sql || sql.length() < 6) {
            return false;
        }
        return "select".equalsIgnoreCase(temp.substring(0, 6));
    }

    final boolean isInsert(String sql) throws SQLServerException {
        this.checkClosed();
        String temp = sql.trim();
        if (null == sql || sql.length() < 6) {
            return false;
        }
        if ("/*".equalsIgnoreCase(temp.substring(0, 2))) {
            int index = temp.indexOf("*/") + 2;
            return this.isInsert(temp.substring(index));
        }
        return "insert".equalsIgnoreCase(temp.substring(0, 6));
    }

    static String replaceParameterWithString(String str, char marker, String replaceStr) {
        int index = 0;
        while ((index = ((String)str).indexOf("" + marker)) >= 0) {
            str = ((String)str).substring(0, index) + replaceStr + ((String)str).substring(index + 1, ((String)str).length());
        }
        return str;
    }

    static String replaceMarkerWithNull(String sql) {
        if (!sql.contains("'")) {
            return SQLServerStatement.replaceParameterWithString(sql, '?', "null");
        }
        StringTokenizer st = new StringTokenizer(sql, "'", true);
        boolean beforeColon = true;
        StringBuilder retSql = new StringBuilder();
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if ("'".equals(str)) {
                retSql.append("'");
                beforeColon = !beforeColon;
                continue;
            }
            if (beforeColon) {
                String repStr = SQLServerStatement.replaceParameterWithString(str, '?', "null");
                retSql.append(repStr);
                continue;
            }
            retSql.append(str);
        }
        return retSql.toString();
    }

    void checkClosed() throws SQLServerException {
        this.connection.checkClosed();
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
    }

    @Override
    public final int getMaxFieldSize() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMaxFieldSize");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getMaxFieldSize", this.maxFieldSize);
        return this.maxFieldSize;
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setMaxFieldSize", max);
        this.checkClosed();
        if (max < 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] msgArgs = new Object[]{max};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
        }
        this.maxFieldSize = max;
        loggerExternal.exiting(this.getClassNameLogging(), "setMaxFieldSize");
    }

    @Override
    public final int getMaxRows() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMaxRows");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getMaxRows", this.maxRows);
        return this.maxRows;
    }

    @Override
    public final long getLargeMaxRows() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLargeMaxRows");
        loggerExternal.exiting(this.getClassNameLogging(), "getLargeMaxRows", this.maxRows);
        return this.getMaxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setMaxRows", max);
        }
        this.checkClosed();
        if (max < 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidRowcount"));
            Object[] msgArgs = new Object[]{max};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
        }
        if (1006 != this.resultSetType) {
            this.maxRows = max;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setMaxRows");
    }

    @Override
    public final void setLargeMaxRows(long max) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLargeMaxRows", max);
        }
        if (max > Integer.MAX_VALUE) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidMaxRows"));
            Object[] msgArgs = new Object[]{max};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
        }
        this.setMaxRows((int)max);
        loggerExternal.exiting(this.getClassNameLogging(), "setLargeMaxRows");
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setEscapeProcessing", enable);
        }
        this.checkClosed();
        this.escapeProcessing = enable;
        loggerExternal.exiting(this.getClassNameLogging(), "setEscapeProcessing");
    }

    @Override
    public final int getQueryTimeout() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getQueryTimeout");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getQueryTimeout", this.queryTimeout);
        return this.queryTimeout;
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setQueryTimeout", seconds);
        this.checkClosed();
        if (seconds < 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] msgArgs = new Object[]{seconds};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
        }
        this.queryTimeout = seconds;
        loggerExternal.exiting(this.getClassNameLogging(), "setQueryTimeout");
    }

    @Override
    public final int getCancelQueryTimeout() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCancelQueryTimeout");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getCancelQueryTimeout", this.cancelQueryTimeoutSeconds);
        return this.cancelQueryTimeoutSeconds;
    }

    @Override
    public final void setCancelQueryTimeout(int seconds) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setCancelQueryTimeout", seconds);
        this.checkClosed();
        if (seconds < 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidCancelQueryTimeout"));
            Object[] msgArgs = new Object[]{seconds};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, true);
        }
        this.cancelQueryTimeoutSeconds = seconds;
        loggerExternal.exiting(this.getClassNameLogging(), "setCancelQueryTimeout");
    }

    @Override
    public final void cancel() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "cancel");
        this.checkClosed();
        if (null != this.currentCommand) {
            this.currentCommand.interrupt(SQLServerException.getErrString("R_queryCanceled"));
        }
        loggerExternal.exiting(this.getClassNameLogging(), "cancel");
    }

    @Override
    public final SQLWarning getWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getWarnings");
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        SQLWarning warn = this.sqlWarnings.elementAt(0);
        loggerExternal.exiting(this.getClassNameLogging(), "getWarnings", warn);
        return warn;
    }

    @Override
    public final void clearWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearWarnings");
        this.checkClosed();
        this.sqlWarnings = null;
        loggerExternal.exiting(this.getClassNameLogging(), "clearWarnings");
    }

    @Override
    public final void setCursorName(String name) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setCursorName", name);
        this.checkClosed();
        this.cursorName = name;
        loggerExternal.exiting(this.getClassNameLogging(), "setCursorName");
    }

    final String getCursorName() {
        return this.cursorName;
    }

    @Override
    public final ResultSet getResultSet() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSet");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSet", this.resultSet);
        return this.resultSet;
    }

    @Override
    public final int getUpdateCount() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getUpdateCount");
        this.checkClosed();
        if (this.updateCount < Integer.MIN_VALUE || this.updateCount > Integer.MAX_VALUE) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_updateCountOutofRange"), null, true);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getUpdateCount", this.updateCount);
        return (int)this.updateCount;
    }

    @Override
    public final long getLargeUpdateCount() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getUpdateCount");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getUpdateCount", this.updateCount);
        return this.updateCount;
    }

    final void ensureExecuteResultsReader(TDSReader tdsReader) {
        this.tdsReader = tdsReader;
    }

    final void processExecuteResults() throws SQLServerException {
        if (this.wasExecuted()) {
            this.processBatch();
            this.checkClosed();
            TDSParser.parse(this.resultsReader(), "batch completion");
            this.ensureExecuteResultsReader(null);
        }
    }

    void processBatch() throws SQLServerException {
        this.processResults();
    }

    final void processResults() throws SQLServerException {
        SQLServerException interruptException = null;
        while (this.moreResults) {
            try {
                this.getNextResult(true);
            }
            catch (SQLServerException e) {
                if (this.moreResults) {
                    if (2 == e.getDriverErrorCode()) {
                        if (!stmtlogger.isLoggable(Level.FINEST)) continue;
                        stmtlogger.finest(this + " ignoring database error: " + e.getErrorCode() + " " + e.getMessage());
                        continue;
                    }
                    if (e.getSQLState() != null && e.getSQLState().equals(SQLState.STATEMENT_CANCELED.getSQLStateCode())) {
                        interruptException = e;
                        continue;
                    }
                }
                this.moreResults = false;
                throw e;
            }
        }
        this.clearLastResult();
        if (null != interruptException) {
            throw interruptException;
        }
    }

    @Override
    public final boolean getMoreResults() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMoreResults");
        this.checkClosed();
        this.getNextResult(true);
        loggerExternal.exiting(this.getClassNameLogging(), "getMoreResults", null != this.resultSet);
        return null != this.resultSet;
    }

    final void clearLastResult() {
        this.updateCount = -1L;
        if (null != this.resultSet) {
            try {
                this.resultSet.close();
            }
            catch (SQLServerException e) {
                stmtlogger.finest(this + " clearing last result; ignored error closing ResultSet: " + e.getErrorCode() + " " + e.getMessage());
            }
            finally {
                this.resultSet = null;
            }
        }
    }

    final boolean getNextResult(boolean clearFlag) throws SQLServerException {
        if (!this.wasExecuted()) {
            this.moreResults = false;
            return false;
        }
        if (clearFlag) {
            this.clearLastResult();
        }
        if (!this.moreResults) {
            return false;
        }
        final class NextResult
        extends TDSTokenHandler {
            private StreamDone stmtDoneToken;
            private boolean isResultSet;
            private StreamRetStatus procedureRetStatToken;

            final boolean isUpdateCount() {
                return null != this.stmtDoneToken;
            }

            final long getUpdateCount() {
                return this.stmtDoneToken.getUpdateCount();
            }

            final boolean isResultSet() {
                return this.isResultSet;
            }

            NextResult() {
                super("getNextResult");
                this.stmtDoneToken = null;
                this.isResultSet = false;
                this.procedureRetStatToken = null;
            }

            @Override
            boolean onColMetaData(TDSReader tdsReader) throws SQLServerException {
                if (null == this.stmtDoneToken && null == this.getDatabaseError()) {
                    this.isResultSet = true;
                }
                return false;
            }

            @Override
            boolean onDone(TDSReader tdsReader) throws SQLServerException {
                StreamDone doneToken = new StreamDone();
                doneToken.setFromTDS(tdsReader);
                if (doneToken.isFinal()) {
                    SQLServerStatement.this.connection.getSessionRecovery().decrementUnprocessedResponseCount();
                }
                if (doneToken.isAttnAck()) {
                    return false;
                }
                if (doneToken.cmdIsDMLOrDDL()) {
                    if (-1L == doneToken.getUpdateCount() && 4 != SQLServerStatement.this.executeMethod) {
                        return true;
                    }
                    if (-1L != doneToken.getUpdateCount() && 1 == SQLServerStatement.this.executeMethod) {
                        return true;
                    }
                    this.stmtDoneToken = doneToken;
                    if (255 != doneToken.getTokenType()) {
                        return false;
                    }
                    if (4 != SQLServerStatement.this.executeMethod) {
                        if (null != SQLServerStatement.this.procedureName) {
                            return false;
                        }
                        if (3 == SQLServerStatement.this.executeMethod) {
                            return false;
                        }
                        if (!SQLServerStatement.this.connection.useLastUpdateCount()) {
                            return false;
                        }
                    }
                } else {
                    if (doneToken.isFinal()) {
                        SQLServerStatement.this.moreResults = false;
                        return false;
                    }
                    if (4 == SQLServerStatement.this.executeMethod && (255 != doneToken.getTokenType() || doneToken.wasRPCInBatch())) {
                        SQLServerStatement.this.moreResults = false;
                        return false;
                    }
                }
                return !doneToken.isError();
            }

            @Override
            boolean onRetStatus(TDSReader tdsReader) throws SQLServerException {
                if (SQLServerStatement.this.consumeExecOutParam(tdsReader)) {
                    SQLServerStatement.this.moreResults = false;
                } else {
                    this.procedureRetStatToken = new StreamRetStatus();
                    this.procedureRetStatToken.setFromTDS(tdsReader);
                }
                return true;
            }

            @Override
            boolean onRetValue(TDSReader tdsReader) throws SQLServerException {
                if (SQLServerStatement.this.moreResults && null == this.procedureRetStatToken) {
                    Parameter p = new Parameter(Util.shouldHonorAEForParameters(SQLServerStatement.this.stmtColumnEncriptionSetting, SQLServerStatement.this.connection));
                    p.skipRetValStatus(tdsReader);
                    p.skipValue(tdsReader, true);
                    return true;
                }
                return false;
            }

            @Override
            boolean onInfo(TDSReader tdsReader) throws SQLServerException {
                StreamInfo infoToken = new StreamInfo();
                infoToken.setFromTDS(tdsReader);
                if (16954 == infoToken.msg.getErrorNumber()) {
                    SQLServerStatement.this.executedSqlDirectly = true;
                }
                SQLWarning warning = new SQLWarning(infoToken.msg.getErrorMessage(), SQLServerException.generateStateCode(SQLServerStatement.this.connection, infoToken.msg.getErrorNumber(), infoToken.msg.getErrorState()), infoToken.msg.getErrorNumber());
                if (SQLServerStatement.this.sqlWarnings == null) {
                    SQLServerStatement.this.sqlWarnings = new Vector();
                } else {
                    int n = SQLServerStatement.this.sqlWarnings.size();
                    SQLWarning w = SQLServerStatement.this.sqlWarnings.elementAt(n - 1);
                    w.setNextWarning(warning);
                }
                SQLServerStatement.this.sqlWarnings.add(warning);
                return true;
            }
        }
        NextResult nextResult = new NextResult();
        TDSParser.parse(this.resultsReader(), nextResult, !clearFlag);
        if (null != nextResult.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(this.connection, null, nextResult.getDatabaseError().getErrorMessage(), nextResult.getDatabaseError(), false);
        }
        if (!clearFlag) {
            return false;
        }
        if (nextResult.isResultSet()) {
            this.resultSet = new SQLServerResultSet(this);
            return true;
        }
        if (nextResult.isUpdateCount()) {
            this.updateCount = nextResult.getUpdateCount();
            return true;
        }
        this.updateCount = -1L;
        if (!this.moreResults) {
            return true;
        }
        this.moreResults = false;
        return false;
    }

    boolean consumeExecOutParam(TDSReader tdsReader) throws SQLServerException {
        if (this.expectCursorOutParams) {
            TDSParser.parse(tdsReader, new StmtExecOutParamHandler(this));
            return true;
        }
        return false;
    }

    @Override
    public final void setFetchDirection(int nDir) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFetchDirection", nDir);
        }
        this.checkClosed();
        if (1000 != nDir && 1001 != nDir && 1002 != nDir || 1000 != nDir && (2003 == this.resultSetType || 2004 == this.resultSetType)) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] msgArgs = new Object[]{nDir};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        this.nFetchDirection = nDir;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchDirection");
    }

    @Override
    public final int getFetchDirection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchDirection");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFetchDirection", this.nFetchDirection);
        return this.nFetchDirection;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFetchSize", rows);
        }
        this.checkClosed();
        if (rows < 0) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.nFetchSize = 0 == rows ? this.defaultFetchSize : rows;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchSize");
    }

    @Override
    public final int getFetchSize() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchSize");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFetchSize", this.nFetchSize);
        return this.nFetchSize;
    }

    @Override
    public final int getResultSetConcurrency() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetConcurrency");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetConcurrency", this.resultSetConcurrency);
        return this.resultSetConcurrency;
    }

    @Override
    public final int getResultSetType() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetType");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetType", this.appResultSetType);
        return this.appResultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch", sql);
        this.checkClosed();
        sql = this.ensureSQLSyntax(sql);
        this.batchStatementBuffer.add(sql);
        loggerExternal.exiting(this.getClassNameLogging(), "addBatch");
    }

    @Override
    public void clearBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearBatch");
        this.checkClosed();
        this.batchStatementBuffer.clear();
        loggerExternal.exiting(this.getClassNameLogging(), "clearBatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLServerException, BatchUpdateException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeBatch");
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.discardLastExecutionResults();
        try {
            int batchSize = this.batchStatementBuffer.size();
            int[] updateCounts = new int[batchSize];
            for (int batchNum = 0; batchNum < batchSize; ++batchNum) {
                updateCounts[batchNum] = -3;
            }
            Throwable lastError = null;
            for (int batchNum = 0; batchNum < batchSize; ++batchNum) {
                try {
                    if (0 == batchNum) {
                        this.executeStatement(new StmtBatchExecCmd(this));
                    } else {
                        this.startResults();
                        if (!this.getNextResult(true)) break;
                    }
                    if (null != this.resultSet) {
                        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, true);
                        continue;
                    }
                    updateCounts[batchNum] = -1 != (int)this.updateCount ? (int)this.updateCount : -2;
                    continue;
                }
                catch (SQLServerException e) {
                    if (this.connection.isSessionUnAvailable() || this.connection.rolledBackTransaction()) {
                        throw e;
                    }
                    lastError = e;
                }
            }
            if (null != lastError) {
                throw new BatchUpdateException(lastError.getMessage(), ((SQLException)lastError).getSQLState(), ((SQLException)lastError).getErrorCode(), updateCounts);
            }
            loggerExternal.exiting(this.getClassNameLogging(), "executeBatch", updateCounts);
            int[] nArray = updateCounts;
            return nArray;
        }
        finally {
            this.batchStatementBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLServerException, BatchUpdateException, SQLTimeoutException {
        loggerExternal.entering(this.getClassNameLogging(), "executeLargeBatch");
        if (loggerExternal.isLoggable(Level.FINER) && Util.isActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        this.discardLastExecutionResults();
        try {
            int batchSize = this.batchStatementBuffer.size();
            long[] updateCounts = new long[batchSize];
            for (int batchNum = 0; batchNum < batchSize; ++batchNum) {
                updateCounts[batchNum] = -3L;
            }
            SQLServerException lastError = null;
            for (int batchNum = 0; batchNum < batchSize; ++batchNum) {
                try {
                    if (0 == batchNum) {
                        this.executeStatement(new StmtBatchExecCmd(this));
                    } else {
                        this.startResults();
                        if (!this.getNextResult(true)) break;
                    }
                    if (null != this.resultSet) {
                        SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, true);
                        continue;
                    }
                    updateCounts[batchNum] = -1L != this.updateCount ? this.updateCount : -2L;
                    continue;
                }
                catch (SQLServerException e) {
                    if (this.connection.isSessionUnAvailable() || this.connection.rolledBackTransaction()) {
                        throw e;
                    }
                    lastError = e;
                }
            }
            if (null != lastError) {
                DriverJDBCVersion.throwBatchUpdateException(lastError, updateCounts);
            }
            loggerExternal.exiting(this.getClassNameLogging(), "executeLargeBatch", updateCounts);
            long[] lArray = updateCounts;
            return lArray;
        }
        finally {
            this.batchStatementBuffer.clear();
        }
    }

    @Override
    public final Connection getConnection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getConnection");
        if (this.bIsClosed) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementIsClosed"), null, false);
        }
        Connection con = this.connection.getConnection();
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", con);
        return con;
    }

    final int getResultSetScrollOpt() {
        int scrollOpt = null == this.inOutParam ? 0 : 4096;
        switch (this.resultSetType) {
            case 2004: {
                return scrollOpt | (1007 == this.resultSetConcurrency ? 16 : 4);
            }
            case 1006: {
                return scrollOpt | 2;
            }
            case 1005: {
                return scrollOpt | 1;
            }
            case 1004: {
                return scrollOpt | 8;
            }
        }
        return 0;
    }

    final int getResultSetCCOpt() {
        switch (this.resultSetConcurrency) {
            case 1007: {
                return 8193;
            }
            case 1008: {
                return 24580;
            }
            case 1009: {
                return 24578;
            }
            case 1010: {
                return 24584;
            }
        }
        return 0;
    }

    private void doExecuteCursored(StmtExecCmd execCmd, String sql) throws SQLServerException {
        if (stmtlogger.isLoggable(Level.FINER)) {
            stmtlogger.finer(this.toString() + " Execute for cursor open SQL:" + sql + " Scrollability:" + this.getResultSetScrollOpt() + " Concurrency:" + this.getResultSetCCOpt());
        }
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        TDSWriter tdsWriter = execCmd.startRequest((byte)3);
        tdsWriter.writeShort((short)-1);
        tdsWriter.writeShort((short)2);
        tdsWriter.writeByte((byte)0);
        tdsWriter.writeByte((byte)0);
        tdsWriter.sendEnclavePackage(sql, execCmd.enclaveCEKs);
        tdsWriter.writeRPCInt(null, 0, true);
        tdsWriter.writeRPCStringUnicode(sql);
        tdsWriter.writeRPCInt(null, this.getResultSetScrollOpt(), false);
        tdsWriter.writeRPCInt(null, this.getResultSetCCOpt(), false);
        tdsWriter.writeRPCInt(null, 0, true);
        this.ensureExecuteResultsReader(execCmd.startResponse(this.isResponseBufferingAdaptive));
        this.startResults();
        this.getNextResult(true);
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getResultSetHoldability");
        this.checkClosed();
        int holdability = this.connection.getHoldability();
        loggerExternal.exiting(this.getClassNameLogging(), "getResultSetHoldability", holdability);
        return holdability;
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{sql, autoGeneratedKeys});
            if (Util.isActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
        }
        this.checkClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] msgArgs = new Object[]{autoGeneratedKeys};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        this.executeStatement(new StmtExecCmd(this, sql, 3, autoGeneratedKeys));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{sql, columnIndexes});
        }
        this.checkClosed();
        if (columnIndexes == null || columnIndexes.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        boolean fSuccess = this.execute(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "execute", fSuccess);
        return fSuccess;
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "execute", new Object[]{sql, columnNames});
        }
        this.checkClosed();
        if (columnNames == null || columnNames.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        boolean fSuccess = this.execute(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "execute", fSuccess);
        return fSuccess;
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{sql, autoGeneratedKeys});
            if (Util.isActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
        }
        this.checkClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] msgArgs = new Object[]{autoGeneratedKeys};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        this.executeStatement(new StmtExecCmd(this, sql, 2, autoGeneratedKeys));
        if (this.updateCount < Integer.MIN_VALUE || this.updateCount > Integer.MAX_VALUE) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_updateCountOutofRange"), null, true);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", this.updateCount);
        return (int)this.updateCount;
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeLargeUpdate", new Object[]{sql, autoGeneratedKeys});
            if (Util.isActivityTraceOn()) {
                loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
            }
        }
        this.checkClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidAutoGeneratedKeys"));
            Object[] msgArgs = new Object[]{autoGeneratedKeys};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        this.executeStatement(new StmtExecCmd(this, sql, 2, autoGeneratedKeys));
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeUpdate", this.updateCount);
        return this.updateCount;
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{sql, columnIndexes});
        }
        this.checkClosed();
        if (columnIndexes == null || columnIndexes.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        int count = this.executeUpdate(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", count);
        return count;
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeLargeUpdate", new Object[]{sql, columnIndexes});
        }
        this.checkClosed();
        if (columnIndexes == null || columnIndexes.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        long count = this.executeLargeUpdate(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeUpdate", count);
        return count;
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", new Object[]{sql, columnNames});
        }
        this.checkClosed();
        if (columnNames == null || columnNames.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        int count = this.executeUpdate(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", count);
        return count;
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "executeLargeUpdate", new Object[]{sql, columnNames});
        }
        this.checkClosed();
        if (columnNames == null || columnNames.length != 1) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        long count = this.executeLargeUpdate(sql, 1);
        loggerExternal.exiting(this.getClassNameLogging(), "executeLargeUpdate", count);
        return count;
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getGeneratedKeys");
        this.checkClosed();
        if (null == this.autoGeneratedKeys) {
            long orgUpd = this.updateCount;
            if (!this.getNextResult(true) || null == this.resultSet) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_statementMustBeExecuted"), null, false);
            }
            this.autoGeneratedKeys = this.resultSet;
            this.updateCount = orgUpd;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getGeneratedKeys", this.autoGeneratedKeys);
        return this.autoGeneratedKeys;
    }

    @Override
    public final boolean getMoreResults(int mode) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getMoreResults", mode);
        }
        this.checkClosed();
        if (2 == mode) {
            SQLServerException.throwNotSupportedException(this.connection, this);
        }
        if (1 != mode && 3 != mode) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_modeSuppliedNotValid"), null, true);
        }
        SQLServerResultSet rsPrevious = this.resultSet;
        boolean fResults = this.getMoreResults();
        if (rsPrevious != null) {
            try {
                rsPrevious.close();
            }
            catch (SQLException e) {
                throw new SQLServerException(e.getMessage(), null, 0, (Throwable)e);
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMoreResults", fResults);
        return fResults;
    }

    @Override
    public boolean isClosed() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isClosed");
        boolean result = this.bIsClosed || this.connection.isSessionUnAvailable();
        loggerExternal.exiting(this.getClassNameLogging(), "isClosed", result);
        return result;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isCloseOnCompletion");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "isCloseOnCompletion", this.isCloseOnCompletion);
        return this.isCloseOnCompletion;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isPoolable");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "isPoolable", this.stmtPoolable);
        return this.stmtPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "setPoolable", poolable);
        this.checkClosed();
        this.stmtPoolable = poolable;
        loggerExternal.exiting(this.getClassNameLogging(), "setPoolable");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor");
        boolean f = iface.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", f);
        return f;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap");
        try {
            t = iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    @Override
    public final void setResponseBuffering(String value) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setResponseBuffering", value);
        this.checkClosed();
        if ("full".equalsIgnoreCase(value)) {
            this.isResponseBufferingAdaptive = false;
            this.wasResponseBufferingSet = true;
        } else if ("adaptive".equalsIgnoreCase(value)) {
            this.isResponseBufferingAdaptive = true;
            this.wasResponseBufferingSet = true;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            Object[] msgArgs = new Object[]{value};
            SQLServerException.makeFromDriverError(this.connection, this, form.format(msgArgs), null, false);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setResponseBuffering");
    }

    @Override
    public final String getResponseBuffering() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getResponseBuffering");
        this.checkClosed();
        String responseBuff = this.wasResponseBufferingSet ? (this.isResponseBufferingAdaptive ? "adaptive" : "full") : this.connection.getResponseBuffering();
        loggerExternal.exiting(this.getClassNameLogging(), "getResponseBuffering", responseBuff);
        return responseBuff;
    }

    public synchronized void registerColumnEncryptionKeyStoreProvidersOnStatement(Map<String, SQLServerColumnEncryptionKeyStoreProvider> clientKeyStoreProviders) throws SQLServerException {
        loggerExternal.entering(this.loggingClassName, "registerColumnEncryptionKeyStoreProvidersOnStatement", "Registering Column Encryption Key Store Providers on Statement");
        this.checkClosed();
        if (null == clientKeyStoreProviders) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_CustomKeyStoreProviderMapNull"), null, 0, false);
        }
        this.statementColumnEncryptionKeyStoreProviders.clear();
        for (Map.Entry<String, SQLServerColumnEncryptionKeyStoreProvider> entry : clientKeyStoreProviders.entrySet()) {
            String providerName = entry.getKey();
            if (null == providerName || 0 == providerName.trim().length()) {
                throw new SQLServerException(null, SQLServerException.getErrString("R_EmptyCustomKeyStoreProviderName"), null, 0, false);
            }
            if (providerName.equalsIgnoreCase(WINDOWS_KEY_STORE_NAME)) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidCustomKeyStoreProviderName"));
                Object[] msgArgs = new Object[]{providerName, WINDOWS_KEY_STORE_NAME};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
            if (null == entry.getValue()) {
                throw new SQLServerException(null, String.format(SQLServerException.getErrString("R_CustomKeyStoreProviderValueNull"), providerName), null, 0, false);
            }
            this.statementColumnEncryptionKeyStoreProviders.put(entry.getKey(), entry.getValue());
        }
        loggerExternal.exiting(this.loggingClassName, "registerColumnEncryptionKeyStoreProvidersOnStatement", "Number of statement-level Key store providers that are registered: " + this.statementColumnEncryptionKeyStoreProviders.size());
    }

    synchronized String getAllStatementColumnEncryptionKeyStoreProviders() {
        String keyStores = "";
        if (0 != this.statementColumnEncryptionKeyStoreProviders.size()) {
            keyStores = this.statementColumnEncryptionKeyStoreProviders.keySet().toString();
        }
        return keyStores;
    }

    synchronized boolean hasColumnEncryptionKeyStoreProvidersRegistered() {
        return null != this.statementColumnEncryptionKeyStoreProviders && this.statementColumnEncryptionKeyStoreProviders.size() > 0;
    }

    synchronized SQLServerColumnEncryptionKeyStoreProvider getColumnEncryptionKeyStoreProvider(String providerName) throws SQLServerException {
        if (null != this.statementColumnEncryptionKeyStoreProviders && this.statementColumnEncryptionKeyStoreProviders.size() > 0) {
            if (this.statementColumnEncryptionKeyStoreProviders.containsKey(providerName)) {
                return this.statementColumnEncryptionKeyStoreProviders.get(providerName);
            }
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UnrecognizedStatementKeyStoreProviderName"));
            Object[] msgArgs = new Object[]{providerName, this.getAllStatementColumnEncryptionKeyStoreProviders()};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return null;
    }

    private final class StmtBatchExecCmd
    extends TDSCommand {
        private static final long serialVersionUID = -4621631860790243331L;
        final SQLServerStatement stmt;

        StmtBatchExecCmd(SQLServerStatement stmt) {
            super(stmt.toString() + " executeBatch", stmt.queryTimeout, stmt.cancelQueryTimeoutSeconds);
            this.stmt = stmt;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatementBatch(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tdsReader) throws SQLServerException {
            SQLServerStatement.this.ensureExecuteResultsReader(tdsReader);
            SQLServerStatement.this.processExecuteResults();
        }
    }

    private final class StmtExecCmd
    extends TDSCommand {
        private static final long serialVersionUID = 4534132352812876292L;
        final SQLServerStatement stmt;
        final String sql;
        final int executeMethod;
        final int autoGeneratedKeys;

        StmtExecCmd(SQLServerStatement stmt, String sql, int executeMethod, int autoGeneratedKeys) {
            super(stmt.toString() + " executeXXX", stmt.queryTimeout, stmt.cancelQueryTimeoutSeconds);
            this.stmt = stmt;
            this.sql = sql;
            this.executeMethod = executeMethod;
            this.autoGeneratedKeys = autoGeneratedKeys;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecuteStatement(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tdsReader) throws SQLServerException {
            SQLServerStatement.this.ensureExecuteResultsReader(tdsReader);
            SQLServerStatement.this.processExecuteResults();
        }
    }

    class StmtExecOutParamHandler
    extends TDSTokenHandler {
        SQLServerStatement statement;

        StmtExecOutParamHandler(SQLServerStatement statement) {
            super("StmtExecOutParamHandler");
            this.statement = statement;
        }

        @Override
        boolean onRetStatus(TDSReader tdsReader) throws SQLServerException {
            new StreamRetStatus().setFromTDS(tdsReader);
            return true;
        }

        @Override
        boolean onRetValue(TDSReader tdsReader) throws SQLServerException {
            if (SQLServerStatement.this.expectCursorOutParams) {
                Parameter param = new Parameter(Util.shouldHonorAEForParameters(SQLServerStatement.this.stmtColumnEncriptionSetting, SQLServerStatement.this.connection));
                param.skipRetValStatus(tdsReader);
                SQLServerStatement.this.serverCursorId = param.getInt(tdsReader, this.statement);
                param.skipValue(tdsReader, true);
                param = new Parameter(Util.shouldHonorAEForParameters(SQLServerStatement.this.stmtColumnEncriptionSetting, SQLServerStatement.this.connection));
                param.skipRetValStatus(tdsReader);
                SQLServerStatement.this.serverCursorRowCount = param.getInt(tdsReader, this.statement);
                if (-1 == SQLServerStatement.this.serverCursorRowCount) {
                    SQLServerStatement.this.serverCursorRowCount = -3;
                }
                param.skipValue(tdsReader, true);
                SQLServerStatement.this.expectCursorOutParams = false;
                return true;
            }
            return false;
        }

        @Override
        boolean onDone(TDSReader tdsReader) throws SQLServerException {
            return false;
        }
    }

    final class ExecuteProperties {
        private final boolean wasResponseBufferingSet;
        private final boolean isResponseBufferingAdaptive;
        private final int holdability;

        final boolean wasResponseBufferingSet() {
            return this.wasResponseBufferingSet;
        }

        final boolean isResponseBufferingAdaptive() {
            return this.isResponseBufferingAdaptive;
        }

        final int getHoldability() {
            return this.holdability;
        }

        ExecuteProperties(SQLServerStatement stmt) {
            this.wasResponseBufferingSet = stmt.wasResponseBufferingSet();
            this.isResponseBufferingAdaptive = stmt.getIsResponseBufferingAdaptive();
            this.holdability = stmt.connection.getHoldabilityInternal();
        }
    }
}

