/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeTIMESTAMP
extends OracleType
implements Serializable {
    static final long serialVersionUID = 3948043338303602796L;
    int precision = 0;

    protected OracleTypeTIMESTAMP() {
    }

    public OracleTypeTIMESTAMP(OracleConnection connection) {
    }

    @Override
    public int getTypeCode() {
        return 93;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        this.precision = tdsReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.precision = in.readByte();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.precision);
    }

    @Override
    protected Object toObject(byte[] bytes, int otype, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (otype) {
            case 1: {
                return new TIMESTAMP(bytes);
            }
            case 2: {
                return TIMESTAMP.toTimestamp(bytes);
            }
            case 3: {
                return bytes;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        TIMESTAMP datum;
        block10: {
            datum = null;
            if (value != null) {
                try {
                    if (value instanceof TIMESTAMP) {
                        datum = (TIMESTAMP)value;
                        break block10;
                    }
                    if (value instanceof byte[]) {
                        datum = new TIMESTAMP((byte[])value);
                        break block10;
                    }
                    if (value instanceof Timestamp) {
                        datum = new TIMESTAMP((Timestamp)value);
                        break block10;
                    }
                    if (value instanceof DATE) {
                        datum = new TIMESTAMP((DATE)value);
                        break block10;
                    }
                    if (value instanceof String) {
                        datum = new TIMESTAMP((String)value);
                        break block10;
                    }
                    if (value instanceof Date) {
                        datum = new TIMESTAMP((Date)value);
                        break block10;
                    }
                    if (value instanceof Time) {
                        datum = new TIMESTAMP((Time)value);
                        break block10;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
                }
                catch (Exception ea) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
                }
            }
        }
        return datum;
    }

    protected Object unpickle81rec(UnpickleContext context, int format, int otype, Map map) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
    }
}

