/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.FakeHttpServletResponse;

public class FakeRequestDispatcher
implements RequestDispatcher {
    private final String url;
    private static final Log log = LogFactory.getLog(FakeRequestDispatcher.class);

    public FakeRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        if (!(response instanceof FakeHttpServletResponse)) {
            throw new IllegalArgumentException("FakeRequestDispatcher requires FakeHttpServletResponse");
        }
        ((FakeHttpServletResponse)response).setForwardedUrl(this.url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("FakeRequestDispatcher: forwarding to URL [" + this.url + "]"));
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        if (!(response instanceof FakeHttpServletResponse)) {
            throw new IllegalArgumentException("FakeRequestDispatcher requires FakeHttpServletResponse");
        }
        ((FakeHttpServletResponse)response).setIncludedUrl(this.url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("FakeRequestDispatcher: including URL [" + this.url + "]"));
        }
    }
}

