/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

public class ScriptedCreator
extends AbstractCreator
implements Creator {
    private static final Log log = LogFactory.getLog(ScriptedCreator.class);
    private Class<?> clazz = null;
    private String language = null;
    private String scriptSrc = null;
    private String scriptPath = null;
    private boolean reloadable = true;
    private boolean useDynamicClasses = false;
    private long scriptModified = -1L;
    private String cachedScript;

    public ScriptedCreator() {
        this.setCacheable(false);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
        if (reloadable) {
            this.setCacheable(false);
        }
    }

    public boolean isUseDynamicClasses() {
        return this.useDynamicClasses;
    }

    public void setUseDynamicClasses(boolean useDynamicClasses) {
        this.useDynamicClasses = useDynamicClasses;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        if (this.scriptSrc != null) {
            throw new IllegalArgumentException("Please specify either the script or scriptPath property but not both.");
        }
        URL url = LocalUtil.getResource(scriptPath);
        if (url != null) {
            this.scriptPath = url.getFile();
            return;
        }
        ServletContext sc = WebContextFactory.get().getServletContext();
        try {
            url = sc.getResource(scriptPath);
            if (url != null) {
                this.scriptPath = url.getFile();
                return;
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        File scriptFile = new File(scriptPath);
        if (scriptFile.exists()) {
            this.scriptPath = scriptFile.getAbsolutePath();
            return;
        }
        log.error((Object)("Script file " + scriptPath + " was not found.  DWR attempts to locate your script file on the classpath (example: /org/yourorg/YourScript.groovy), the servlet context (example: /WEB-INF/groovyScripts/YourScript.groovy), or as a path on the file system (C:/groovyScripts/YourScript.groovy). DWR will be unable to access this script."));
    }

    private boolean scriptUpdated() {
        if (this.scriptPath == null) {
            return false;
        }
        File scriptFile = this.getScriptFile();
        if (this.scriptModified < scriptFile.lastModified()) {
            log.debug((Object)"Script has been updated.");
            this.clazz = null;
            return true;
        }
        return false;
    }

    public String getScript() throws InstantiationException {
        String string;
        if (this.scriptSrc != null) {
            return this.scriptSrc;
        }
        if (this.scriptPath == null) {
            throw new InstantiationException("scriptPath was not specified or a script could not be located at scriptPath.");
        }
        if (!(this.cachedScript == null || this.reloadable && this.scriptUpdated())) {
            return this.cachedScript;
        }
        log.debug((Object)("Loading Script from Path: " + this.scriptPath));
        RandomAccessFile in = null;
        try {
            File scriptFile = this.getScriptFile();
            this.scriptModified = scriptFile.lastModified();
            in = new RandomAccessFile(scriptFile, "r");
            byte[] bytes = new byte[(int)in.length()];
            in.readFully(bytes);
            string = this.cachedScript = new String(bytes);
        }
        catch (Exception ex) {
            try {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new InstantiationException("Missing or empty script.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public void setScript(String scriptSrc) {
        if (this.scriptPath != null) {
            throw new IllegalArgumentException("Please specify either the script or scriptPath property but not both.");
        }
        if (scriptSrc == null || scriptSrc.trim().length() == 0) {
            throw new IllegalArgumentException("Please specify either the script or scriptPath property but not both.");
        }
        this.scriptSrc = scriptSrc;
    }

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + classname, ex);
        }
    }

    @Override
    public Class<?> getType() {
        if (this.clazz == null || this.reloadable && this.scriptUpdated()) {
            try {
                this.clazz = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error((Object)"Failed to instansiate object to detect type.", (Throwable)ex);
                return Object.class;
            }
        }
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        if (this.scriptSrc == null && this.scriptPath == null) {
            throw new InstantiationException("Either an inline script was not specified, or a scriptPath was not specified, or the scriptPath could not be properly located.");
        }
        try {
            if (this.useDynamicClasses && this.clazz != null) {
                return this.clazz.newInstance();
            }
            BSFManager bsfman = new BSFManager();
            try {
                WebContext context = WebContextFactory.get();
                bsfman.declareBean("context", (Object)context, context.getClass());
            }
            catch (BSFException ex) {
                log.warn((Object)("Failed to register WebContext with scripting engine: " + ex.getMessage()));
            }
            String languageToUse = this.language != null ? this.language : BSFManager.getLangFromFilename((String)this.scriptPath);
            return bsfman.eval(languageToUse, null == this.scriptPath ? "dwr.xml" : this.scriptPath, 0, 0, (Object)this.getScript());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to getInstance", ex);
        }
    }

    private File getScriptFile() {
        return new File(this.scriptPath);
    }
}

