/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.ConversionException;
import org.directwebremoting.convert.BasicObjectConverter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.PropertyDescriptorProperty;
import org.directwebremoting.util.LocalUtil;

public class BeanConverter
extends BasicObjectConverter {
    @Override
    public Map<String, Property> getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws ConversionException {
        return this.getPropertyMapFromClass(example.getClass(), readRequired, writeRequired);
    }

    @Override
    public Map<String, Property> getPropertyMapFromClass(Class<?> type, boolean readRequired, boolean writeRequired) throws ConversionException {
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (PropertyDescriptor descriptor : descriptors) {
                String name = descriptor.getName();
                if ("class".equals(name) || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && LocalUtil.getWriteMethod(type, descriptor) == null) continue;
                properties.put(name, new PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (IntrospectionException ex) {
            throw new ConversionException(type, (Throwable)ex);
        }
    }

    @Override
    protected Property createTypeHintContext(InboundContext inctx, Property property) {
        return property;
    }
}

