module AArch64
  module SystemRegisters
    MRS_MSR_64 = Struct.new(:op0, :op1, :CRn, :CRm, :op2)
    OSDTRRX_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b0000, 0b010)
    MDCCINT_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b0010, 0b000)
    MDSCR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b0010, 0b010)
    OSDTRTX_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b0011, 0b010)
    OSECCR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b0110, 0b010)
    DBGBVR0_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0, 0b100)
    DBGBVR1_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1, 0b100)
    DBGBVR2_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b10, 0b100)
    DBGBVR3_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b11, 0b100)
    DBGBVR4_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b100, 0b100)
    DBGBVR5_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b101, 0b100)
    DBGBVR6_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b110, 0b100)
    DBGBVR7_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b111, 0b100)
    DBGBVR8_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1000, 0b100)
    DBGBVR9_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1001, 0b100)
    DBGBVR10_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1010, 0b100)
    DBGBVR11_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1011, 0b100)
    DBGBVR12_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1100, 0b100)
    DBGBVR13_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1101, 0b100)
    DBGBVR14_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1110, 0b100)
    DBGBVR15_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1111, 0b100)
    DBGBCR0_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0, 0b101)
    DBGBCR1_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1, 0b101)
    DBGBCR2_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b10, 0b101)
    DBGBCR3_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b11, 0b101)
    DBGBCR4_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b100, 0b101)
    DBGBCR5_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b101, 0b101)
    DBGBCR6_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b110, 0b101)
    DBGBCR7_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b111, 0b101)
    DBGBCR8_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1000, 0b101)
    DBGBCR9_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1001, 0b101)
    DBGBCR10_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1010, 0b101)
    DBGBCR11_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1011, 0b101)
    DBGBCR12_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1100, 0b101)
    DBGBCR13_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1101, 0b101)
    DBGBCR14_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1110, 0b101)
    DBGBCR15_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1111, 0b101)
    DBGWVR0_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0, 0b110)
    DBGWVR1_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1, 0b110)
    DBGWVR2_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b10, 0b110)
    DBGWVR3_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b11, 0b110)
    DBGWVR4_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b100, 0b110)
    DBGWVR5_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b101, 0b110)
    DBGWVR6_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b110, 0b110)
    DBGWVR7_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b111, 0b110)
    DBGWVR8_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1000, 0b110)
    DBGWVR9_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1001, 0b110)
    DBGWVR10_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1010, 0b110)
    DBGWVR11_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1011, 0b110)
    DBGWVR12_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1100, 0b110)
    DBGWVR13_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1101, 0b110)
    DBGWVR14_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1110, 0b110)
    DBGWVR15_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1111, 0b110)
    DBGWCR0_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0, 0b111)
    DBGWCR1_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1, 0b111)
    DBGWCR2_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b10, 0b111)
    DBGWCR3_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b11, 0b111)
    DBGWCR4_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b100, 0b111)
    DBGWCR5_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b101, 0b111)
    DBGWCR6_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b110, 0b111)
    DBGWCR7_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b111, 0b111)
    DBGWCR8_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1000, 0b111)
    DBGWCR9_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1001, 0b111)
    DBGWCR10_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1010, 0b111)
    DBGWCR11_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1011, 0b111)
    DBGWCR12_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1100, 0b111)
    DBGWCR13_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1101, 0b111)
    DBGWCR14_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1110, 0b111)
    DBGWCR15_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0000, 0b1111, 0b111)
    MDRAR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0001, 0b0000, 0b000)
    OSLAR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0001, 0b0000, 0b100)
    OSLSR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0001, 0b0001, 0b100)
    OSDLR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0001, 0b0011, 0b100)
    DBGPRCR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0001, 0b0100, 0b100)
    DBGCLAIMSET_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0111, 0b1000, 0b110)
    DBGCLAIMCLR_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0111, 0b1001, 0b110)
    DBGAUTHSTATUS_EL1 = MRS_MSR_64.new(0b10, 0b000, 0b0111, 0b1110, 0b110)
    MDCCSR_EL0 = MRS_MSR_64.new(0b10, 0b011, 0b0000, 0b0001, 0b000)
    DBGDTR_EL0 = MRS_MSR_64.new(0b10, 0b011, 0b0000, 0b0100, 0b000)
    DBGDTRRX_EL0 = MRS_MSR_64.new(0b10, 0b011, 0b0000, 0b0101, 0b000)
    DBGDTRTX_EL0 = MRS_MSR_64.new(0b10, 0b011, 0b0000, 0b0101, 0b000)
    DBGVCR32_EL2 = MRS_MSR_64.new(0b10, 0b100, 0b0000, 0b0111, 0b000)
    MIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0000, 0b000)
    MPIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0000, 0b101)
    REVIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0000, 0b110)
    ID_PFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b000)
    ID_PFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b001)
    ID_DFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b010)
    ID_AFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b011)
    ID_MMFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b100)
    ID_MMFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b101)
    ID_MMFR2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b110)
    ID_MMFR3_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0001, 0b111)
    ID_ISAR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b000)
    ID_ISAR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b001)
    ID_ISAR2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b010)
    ID_ISAR3_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b011)
    ID_ISAR4_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b100)
    ID_ISAR5_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b101)
    ID_MMFR4_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b110)
    ID_ISAR6_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0010, 0b111)
    MVFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b000)
    MVFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b001)
    MVFR2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b010)
    ID_PFR2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b100)
    ID_DFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b101)
    ID_MMFR5_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0011, 0b110)
    ID_AA64PFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0100, 0b000)
    ID_AA64PFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0100, 0b001)
    ID_AA64ZFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0100, 0b100)
    ID_AA64DFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0101, 0b000)
    ID_AA64DFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0101, 0b001)
    ID_AA64AFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0101, 0b100)
    ID_AA64AFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0101, 0b101)
    ID_AA64ISAR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0110, 0b000)
    ID_AA64ISAR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0110, 0b001)
    ID_AA64MMFR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0111, 0b000)
    ID_AA64MMFR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0111, 0b001)
    ID_AA64MMFR2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0000, 0b0111, 0b010)
    SCTLR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0000, 0b000)
    ACTLR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0000, 0b001)
    CPACR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0000, 0b010)
    RGSR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0000, 0b101)
    GCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0000, 0b110)
    ZCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0010, 0b000)
    TRFCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0001, 0b0010, 0b001)
    TTBR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0000, 0b000)
    TTBR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0000, 0b001)
    TCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0000, 0b010)
    APIAKeyLo_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0001, 0b000)
    APIAKeyHi_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0001, 0b001)
    APIBKeyLo_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0001, 0b010)
    APIBKeyHi_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0001, 0b011)
    APDAKeyLo_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0010, 0b000)
    APDAKeyHi_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0010, 0b001)
    APDBKeyLo_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0010, 0b010)
    APDBKeyHi_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0010, 0b011)
    APGAKeyLo_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0011, 0b000)
    APGAKeyHi_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0010, 0b0011, 0b001)
    SPSR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0000, 0b000)
    ELR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0000, 0b001)
    SP_EL0 = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0001, 0b000)
    SPSel = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0010, 0b000)
    CurrentEL = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0010, 0b010)
    PAN = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0010, 0b011)
    UAO = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0010, 0b100)
    ICC_PMR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0100, 0b0110, 0b000)
    AFSR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0001, 0b000)
    AFSR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0001, 0b001)
    ESR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0010, 0b000)
    ERRIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0011, 0b000)
    ERRSELR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0011, 0b001)
    ERXFR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b000)
    ERXCTLR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b001)
    ERXSTATUS_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b010)
    ERXADDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b011)
    ERXPFGF_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b100)
    ERXPFGCTL_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b101)
    ERXPFGCDN_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0100, 0b110)
    ERXMISC0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0101, 0b000)
    ERXMISC1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0101, 0b001)
    ERXMISC2_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0101, 0b010)
    ERXMISC3_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0101, 0b011)
    TFSR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0110, 0b000)
    TFSRE0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0101, 0b0110, 0b001)
    FAR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0110, 0b0000, 0b000)
    PAR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b0111, 0b0100, 0b000)
    PMSCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b000)
    PMSICR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b010)
    PMSIRR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b011)
    PMSFCR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b100)
    PMSEVFR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b101)
    PMSLATFR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b110)
    PMSIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1001, 0b111)
    PMBLIMITR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1010, 0b000)
    PMBPTR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1010, 0b001)
    PMBSR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1010, 0b011)
    PMBIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1010, 0b111)
    PMINTENSET_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1110, 0b001)
    PMINTENCLR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1110, 0b010)
    PMMIR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1001, 0b1110, 0b110)
    MAIR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0010, 0b000)
    AMAIR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0011, 0b000)
    LORSA_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b000)
    LOREA_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b001)
    LORN_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b010)
    LORC_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b011)
    MPAMIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b100)
    LORID_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0100, 0b111)
    MPAM1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0101, 0b000)
    MPAM0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1010, 0b0101, 0b001)
    VBAR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b0000, 0b000)
    RVBAR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b0000, 0b001)
    RMR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b0000, 0b010)
    ISR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b0001, 0b000)
    DISR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b0001, 0b001)
    ICC_IAR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1000, 0b000)
    ICC_EOIR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1000, 0b001)
    ICC_HPPIR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1000, 0b010)
    ICC_BPR0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1000, 0b011)
    ICC_DIR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1011, 0b001)
    ICC_RPR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1011, 0b011)
    ICC_SGI1R_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1011, 0b101)
    ICC_ASGI1R_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1011, 0b110)
    ICC_SGI0R_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1011, 0b111)
    ICC_IAR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b000)
    ICC_EOIR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b001)
    ICC_HPPIR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b010)
    ICC_BPR1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b011)
    ICC_CTLR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b100)
    ICC_SRE_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b101)
    ICC_IGRPEN0_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b110)
    ICC_IGRPEN1_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1100, 0b1100, 0b111)
    CONTEXTIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1101, 0b0000, 0b001)
    TPIDR_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1101, 0b0000, 0b100)
    SCXTNUM_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1101, 0b0000, 0b111)
    CNTKCTL_EL1 = MRS_MSR_64.new(0b11, 0b000, 0b1110, 0b0001, 0b000)
    CCSIDR_EL1 = MRS_MSR_64.new(0b11, 0b001, 0b0000, 0b0000, 0b000)
    CLIDR_EL1 = MRS_MSR_64.new(0b11, 0b001, 0b0000, 0b0000, 0b001)
    CCSIDR2_EL1 = MRS_MSR_64.new(0b11, 0b001, 0b0000, 0b0000, 0b010)
    GMID_EL1 = MRS_MSR_64.new(0b11, 0b001, 0b0000, 0b0000, 0b100)
    AIDR_EL1 = MRS_MSR_64.new(0b11, 0b001, 0b0000, 0b0000, 0b111)
    CSSELR_EL1 = MRS_MSR_64.new(0b11, 0b010, 0b0000, 0b0000, 0b000)
    CTR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b0000, 0b0000, 0b001)
    DCZID_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b0000, 0b0000, 0b111)
    RNDR = MRS_MSR_64.new(0b11, 0b011, 0b0010, 0b0100, 0b000)
    RNDRRS = MRS_MSR_64.new(0b11, 0b011, 0b0010, 0b0100, 0b001)
    NZCV = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0010, 0b000)
    DAIF = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0010, 0b001)
    DIT = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0010, 0b101)
    SSBS = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0010, 0b110)
    TCO = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0010, 0b111)
    FPCR = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0100, 0b000)
    FPSR = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0100, 0b001)
    DSPSR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0101, 0b000)
    DLR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b0100, 0b0101, 0b001)
    PMCR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b000)
    PMCNTENSET_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b001)
    PMCNTENCLR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b010)
    PMOVSCLR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b011)
    PMSWINC_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b100)
    PMSELR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b101)
    PMCEID0_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b110)
    PMCEID1_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1100, 0b111)
    PMCCNTR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1101, 0b000)
    PMXEVTYPER_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1101, 0b001)
    PMXEVCNTR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1101, 0b010)
    PMUSERENR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1110, 0b000)
    PMOVSSET_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1001, 0b1110, 0b011)
    TPIDR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0000, 0b010)
    TPIDRRO_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0000, 0b011)
    SCXTNUM_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0000, 0b111)
    AMCR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b000)
    AMCFGR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b001)
    AMCGCR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b010)
    AMUSERENR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b011)
    AMCNTENCLR0_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b100)
    AMCNTENSET0_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b101)
    AMCG1IDR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0010, 0b110)
    AMCNTENCLR1_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0011, 0b000)
    AMCNTENSET1_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1101, 0b0011, 0b001)
    CNTFRQ_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0000, 0b000)
    CNTPCT_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0000, 0b001)
    CNTVCT_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0000, 0b010)
    CNTPCTSS_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0000, 0b101)
    CNTVCTSS_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0000, 0b110)
    CNTP_TVAL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0010, 0b000)
    CNTP_CTL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0010, 0b001)
    CNTP_CVAL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0010, 0b010)
    CNTV_TVAL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0011, 0b000)
    CNTV_CTL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0011, 0b001)
    CNTV_CVAL_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b0011, 0b010)
    PMCCFILTR_EL0 = MRS_MSR_64.new(0b11, 0b011, 0b1110, 0b1111, 0b111)
    VPIDR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0000, 0b0000, 0b000)
    VMPIDR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0000, 0b0000, 0b101)
    SCTLR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0000, 0b000)
    ACTLR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0000, 0b001)
    HCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b000)
    MDCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b001)
    CPTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b010)
    HSTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b011)
    HFGRTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b100)
    HFGWTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b101)
    HFGITR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b110)
    HACR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0001, 0b111)
    ZCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0010, 0b000)
    TRFCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0010, 0b001)
    SDER32_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0001, 0b0011, 0b001)
    TTBR0_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0000, 0b000)
    TTBR1_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0000, 0b001)
    TCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0000, 0b010)
    VTTBR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0001, 0b000)
    VTCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0001, 0b010)
    VNCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0010, 0b000)
    VSTTBR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0110, 0b000)
    VSTCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0010, 0b0110, 0b010)
    DACR32_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0011, 0b0000, 0b000)
    HDFGRTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0011, 0b0001, 0b100)
    HDFGWTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0011, 0b0001, 0b101)
    HAFGRTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0011, 0b0001, 0b110)
    SPSR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0000, 0b000)
    ELR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0000, 0b001)
    SP_EL1 = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0001, 0b000)
    SPSR_irq = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0011, 0b000)
    SPSR_abt = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0011, 0b001)
    SPSR_und = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0011, 0b010)
    SPSR_fiq = MRS_MSR_64.new(0b11, 0b100, 0b0100, 0b0011, 0b011)
    IFSR32_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0000, 0b001)
    AFSR0_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0001, 0b000)
    AFSR1_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0001, 0b001)
    ESR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0010, 0b000)
    VSESR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0010, 0b011)
    FPEXC32_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0011, 0b000)
    TFSR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0101, 0b0110, 0b000)
    FAR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0110, 0b0000, 0b000)
    HPFAR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b0110, 0b0000, 0b100)
    PMSCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1001, 0b1001, 0b000)
    MAIR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0010, 0b000)
    AMAIR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0011, 0b000)
    MPAMHCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0100, 0b000)
    MPAMVPMV_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0100, 0b001)
    MPAM2_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0101, 0b000)
    MPAMVPM0_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b000)
    MPAMVPM1_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b001)
    MPAMVPM2_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b010)
    MPAMVPM3_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b011)
    MPAMVPM4_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b100)
    MPAMVPM5_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b101)
    MPAMVPM6_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b110)
    MPAMVPM7_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1010, 0b0110, 0b111)
    VBAR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b0000, 0b000)
    RVBAR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b0000, 0b001)
    RMR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b0000, 0b010)
    VDISR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b0001, 0b001)
    ICC_SRE_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1001, 0b101)
    ICH_HCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b000)
    ICH_VTR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b001)
    ICH_MISR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b010)
    ICH_EISR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b011)
    ICH_ELRSR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b101)
    ICH_VMCR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1100, 0b1011, 0b111)
    CONTEXTIDR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1101, 0b0000, 0b001)
    TPIDR_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1101, 0b0000, 0b010)
    SCXTNUM_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1101, 0b0000, 0b111)
    CNTVOFF_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0000, 0b011)
    CNTPOFF_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0000, 0b110)
    CNTHCTL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0001, 0b000)
    CNTHP_TVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0010, 0b000)
    CNTHP_CTL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0010, 0b001)
    CNTHP_CVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0010, 0b010)
    CNTHV_TVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0011, 0b000)
    CNTHV_CTL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0011, 0b001)
    CNTHV_CVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0011, 0b010)
    CNTHVS_TVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0100, 0b000)
    CNTHVS_CTL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0100, 0b001)
    CNTHVS_CVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0100, 0b010)
    CNTHPS_TVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0101, 0b000)
    CNTHPS_CTL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0101, 0b001)
    CNTHPS_CVAL_EL2 = MRS_MSR_64.new(0b11, 0b100, 0b1110, 0b0101, 0b010)
    SCTLR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0000, 0b000)
    ACTLR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0000, 0b001)
    SCR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0001, 0b000)
    SDER32_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0001, 0b001)
    CPTR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0001, 0b010)
    ZCR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0010, 0b000)
    MDCR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0001, 0b0011, 0b001)
    TTBR0_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0010, 0b0000, 0b000)
    TCR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0010, 0b0000, 0b010)
    SPSR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0100, 0b0000, 0b000)
    ELR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0100, 0b0000, 0b001)
    SP_EL2 = MRS_MSR_64.new(0b11, 0b110, 0b0100, 0b0001, 0b000)
    AFSR0_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0101, 0b0001, 0b000)
    AFSR1_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0101, 0b0001, 0b001)
    ESR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0101, 0b0010, 0b000)
    TFSR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0101, 0b0110, 0b000)
    FAR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b0110, 0b0000, 0b000)
    MAIR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1010, 0b0010, 0b000)
    AMAIR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1010, 0b0011, 0b000)
    MPAM3_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1010, 0b0101, 0b000)
    VBAR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b0000, 0b000)
    RVBAR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b0000, 0b001)
    RMR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b0000, 0b010)
    ICC_CTLR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b1100, 0b100)
    ICC_SRE_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b1100, 0b101)
    ICC_IGRPEN1_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1100, 0b1100, 0b111)
    TPIDR_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1101, 0b0000, 0b010)
    SCXTNUM_EL3 = MRS_MSR_64.new(0b11, 0b110, 0b1101, 0b0000, 0b111)
    CNTPS_TVAL_EL1 = MRS_MSR_64.new(0b11, 0b111, 0b1110, 0b0010, 0b000)
    CNTPS_CTL_EL1 = MRS_MSR_64.new(0b11, 0b111, 0b1110, 0b0010, 0b001)
    CNTPS_CVAL_EL1 = MRS_MSR_64.new(0b11, 0b111, 0b1110, 0b0010, 0b010)
  end
end
