# -*- coding: binary -*-


module Msf

###
#
# This mixin provides a DHCPServer
#
###
module Exploit::DHCPServer

  def initialize(info = {})
    super(update_info(info,
      'Stance' => Msf::Exploit::Stance::Passive,
    ))

    register_options(
      [
        OptString.new('SRVHOST',     [ true,  "The IP of the DHCP server" ]),
        OptString.new('NETMASK',     [ true,  "The netmask of the local subnet" ]),
        OptString.new('DHCPIPSTART', [ false, "The first IP to give out" ]),
        OptString.new('DHCPIPEND',   [ false, "The last IP to give out" ]),
        OptString.new('ROUTER',      [ false, "The router IP address" ]),
        OptString.new('BROADCAST',   [ false, "The broadcast address to send to" ]),
        OptString.new('DNSSERVER',   [ false, "The DNS server IP address" ]),
        OptString.new('DOMAINNAME',  [ false, "The optional domain name to assign" ]),
        OptString.new('HOSTNAME',    [ false, "The optional hostname to assign" ]),
        OptString.new('HOSTSTART',   [ false, "The optional host integer counter" ]),
        OptString.new('FILENAME',    [ false, "The optional filename of a tftp boot server" ])
      ], self.class)

    @dhcp = nil
  end

  def start_service(hash = {}, context = {})
    @dhcp = Rex::Proto::DHCP::Server.new(hash, context)
    vprint_status("Starting DHCP server")
    @dhcp.start
    add_socket(@dhcp.sock)
    @dhcp
  end

  def stop_service
    vprint_status("Stopping DHCP server")
    @dhcp.stop
  end

  attr_accessor :dhcp
end

end
