/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2020, Google Inc.
 *
 * Image Processing Algorithm interface for ipu3
 *
 * This file is auto-generated. Do not edit.
 */

#pragma once


#include <string>
#include <type_traits>
#include <utility>
#include <vector>

#include <libcamera/base/flags.h>
#include <libcamera/base/signal.h>

#include <libcamera/controls.h>
#include <libcamera/framebuffer.h>
#include <libcamera/geometry.h>

#include <libcamera/ipa/core_ipa_interface.h>
#include <libcamera/ipa/ipa_interface.h>

namespace libcamera {

namespace ipa {

namespace ipu3 {




enum class _IPU3Cmd {
	Exit = 0,
	Init = 1,
	Start = 2,
	Stop = 3,
	Configure = 4,
	MapBuffers = 5,
	UnmapBuffers = 6,
	QueueRequest = 7,
	ComputeParams = 8,
	ProcessStats = 9,
};

enum class _IPU3EventCmd {
	SetSensorControls = 1,
	ParamsComputed = 2,
	MetadataReady = 3,
};


struct IPAConfigInfo
{
public:
#ifndef __DOXYGEN__
	IPAConfigInfo() = default;

	template<
		typename T1 = IPACameraSensorInfo,
		typename T2 = ControlInfoMap,
		typename T3 = ControlInfoMap,
		typename T4 = Size,
		typename T5 = Size,
		std::enable_if_t<std::is_convertible_v<T1&&, IPACameraSensorInfo>> * = nullptr,
		std::enable_if_t<std::is_convertible_v<T2&&, ControlInfoMap>> * = nullptr,
		std::enable_if_t<std::is_convertible_v<T3&&, ControlInfoMap>> * = nullptr,
		std::enable_if_t<std::is_convertible_v<T4&&, Size>> * = nullptr,
		std::enable_if_t<std::is_convertible_v<T5&&, Size>> * = nullptr
	>
	IPAConfigInfo(T1 &&_sensorInfo, T2 &&_sensorControls, T3 &&_lensControls, T4 &&_bdsOutputSize, T5 &&_iif)
		: sensorInfo(std::forward<T1>(_sensorInfo))
		, sensorControls(std::forward<T2>(_sensorControls))
		, lensControls(std::forward<T3>(_lensControls))
		, bdsOutputSize(std::forward<T4>(_bdsOutputSize))
		, iif(std::forward<T5>(_iif))
	{
	}
#endif


	IPACameraSensorInfo sensorInfo;
	ControlInfoMap sensorControls;
	ControlInfoMap lensControls;
	Size bdsOutputSize;
	Size iif;
};

class IPAIPU3Interface : public IPAInterface
{
public:

	virtual int32_t init(
		const IPASettings &settings,
		const IPACameraSensorInfo &sensorInfo,
		const ControlInfoMap &sensorControls,
		ControlInfoMap *ipaControls) = 0;

	virtual int32_t start() = 0;

	virtual void stop() = 0;

	virtual int32_t configure(
		const IPAConfigInfo &configInfo,
		ControlInfoMap *ipaControls) = 0;

	virtual void mapBuffers(
		const std::vector<libcamera::IPABuffer> &buffers) = 0;

	virtual void unmapBuffers(
		const std::vector<uint32_t> &ids) = 0;

	virtual void queueRequest(
		const uint32_t frame,
		const ControlList &controls) = 0;

	virtual void computeParams(
		const uint32_t frame,
		const uint32_t bufferId) = 0;

	virtual void processStats(
		const uint32_t frame,
		const int64_t frameTimestamp,
		const uint32_t bufferId,
		const ControlList &sensorControls) = 0;

	Signal<uint32_t, const ControlList &, const ControlList &> setSensorControls;

	Signal<uint32_t> paramsComputed;

	Signal<uint32_t, const ControlList &> metadataReady;
};

} /* namespace ipu3 */

} /* namespace ipa */

} /* namespace libcamera */