/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.KeyStoreException;
import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class KeyStoreTrustAnchorRepository
implements TrustAnchorRepository {
    private final Set<TrustAnchor> trustAnchors;

    public KeyStoreTrustAnchorRepository(KeyStore keyStore) {
        AssertUtil.notNull(keyStore, "keyStore must not be null");
        this.trustAnchors = KeyStoreTrustAnchorRepository.loadTrustAnchors(keyStore);
    }

    @Deprecated(forRemoval=true)
    public KeyStoreTrustAnchorRepository(Path keyStore, String password) {
        this(KeyStoreTrustAnchorRepository.loadKeyStore(keyStore, password));
    }

    public static KeyStoreTrustAnchorRepository createFromKeyStoreFilePath(Path keyStore, String password) {
        KeyStore keyStoreObj = KeyStoreTrustAnchorRepository.loadKeyStore(keyStore, password);
        return new KeyStoreTrustAnchorRepository(keyStoreObj);
    }

    @Override
    public Set<TrustAnchor> find(AAGUID aaguid) {
        return this.trustAnchors;
    }

    @Override
    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return this.trustAnchors;
    }

    @NotNull
    private static Set<TrustAnchor> loadTrustAnchors(KeyStore keyStore) {
        try {
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (String alias : aliases) {
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
            return trustAnchors;
        }
        catch (java.security.KeyStoreException e) {
            throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
        }
    }

    @NotNull
    private static KeyStore loadKeyStore(Path keyStore, String password) {
        KeyStore keyStore2;
        block8: {
            AssertUtil.notNull(keyStore, "keyStore must not be null");
            AssertUtil.notNull(password, "password must not be null");
            InputStream inputStream = Files.newInputStream(keyStore, new OpenOption[0]);
            try {
                KeyStore keyStoreObject = CertificateUtil.createKeyStore();
                keyStoreObject.load(inputStream, password.toCharArray());
                keyStore2 = keyStoreObject;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                    throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
                }
            }
            inputStream.close();
        }
        return keyStore2;
    }
}

