/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class MainEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        GroupingSpecification groupingSpec = rb.getGroupingSpec();
        String[] entries = groupingSpec.getFields();
        if (!(entries != null && Array.getLength(entries) != 0 || (entries = groupingSpec.getQueries()) != null && Array.getLength(entries) != 0)) {
            return;
        }
        Object value = result.get(entries[0]);
        if (TopGroups.class.isInstance(value)) {
            TopGroups topGroups = (TopGroups)value;
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart((long)rb.getGroupingSpec().getGroupSortSpec().getOffset());
            docList.setNumFound((long)rb.totalHitCount);
            float maxScore = Float.NEGATIVE_INFINITY;
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    SolrDocument solrDocument;
                    if (maxScore < scoreDoc.score) {
                        maxScore = scoreDoc.score;
                    }
                    if ((solrDocument = solrDocumentSource.retrieve(scoreDoc)) == null) continue;
                    docList.add((Object)solrDocument);
                }
            }
            if (maxScore != Float.NEGATIVE_INFINITY) {
                docList.setMaxScore(Float.valueOf(maxScore));
            }
            rb.rsp.addResponse(docList);
        } else if (value instanceof QueryCommandResult) {
            QueryCommandResult queryCommandResult = (QueryCommandResult)value;
            SolrDocumentList docList = new SolrDocumentList();
            TopDocs topDocs = queryCommandResult.getTopDocs();
            docList.setStart((long)rb.getGroupingSpec().getGroupSortSpec().getOffset());
            docList.setNumFound(topDocs.totalHits.value);
            if (!Float.isNaN(queryCommandResult.getMaxScore())) {
                docList.setMaxScore(Float.valueOf(queryCommandResult.getMaxScore()));
            }
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                SolrDocument solrDocument = solrDocumentSource.retrieve(scoreDoc);
                if (solrDocument == null) continue;
                docList.add((Object)solrDocument);
            }
            rb.rsp.addResponse(docList);
        }
    }
}

