/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLWriter
extends TextResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static float CURRENT_VERSION = 2.2f;
    private static final char[] XML_START1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private static final char[] XML_STYLESHEET = "<?xml-stylesheet type=\"text/xsl\" href=\"".toCharArray();
    private static final char[] XML_STYLESHEET_END = "\"?>\n".toCharArray();
    private static final char[] XML_START2_NOSCHEMA = "<response>\n".toCharArray();
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        try (TextResponseWriter xmlWriter = null;){
            xmlWriter = new XMLWriter(writer, req, rsp);
            ((XMLWriter)xmlWriter).writeResponse();
        }
    }

    public XMLWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
        String version = req.getParams().get("version");
        float ver = version == null ? CURRENT_VERSION : Float.parseFloat(version);
        this.version = (int)(ver * 1000.0f);
        if (this.version < 2200) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "XMLWriter does not support version: " + version);
        }
    }

    public void writeResponse() throws IOException {
        int start;
        this.writer.write(XML_START1);
        String stylesheet = this.req.getParams().get("stylesheet");
        if (stylesheet != null && stylesheet.length() > 0) {
            this.writer.write(XML_STYLESHEET);
            XML.escapeAttributeValue((String)stylesheet, (Writer)this.writer);
            this.writer.write(XML_STYLESHEET_END);
        }
        this.writer.write(XML_START2_NOSCHEMA);
        Boolean omitHeader = this.req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            this.rsp.removeResponseHeader();
        }
        NamedList<Object> lst = this.rsp.getValues();
        int sz = lst.size();
        for (int i = start = 0; i < sz; ++i) {
            this.writeVal(lst.getName(i), lst.getVal(i));
        }
        this.writer.write("\n</response>\n");
    }

    private void writeAttr(String name, String val) throws IOException {
        this.writeAttr(name, val, true);
    }

    public void writeAttr(String name, String val, boolean escape) throws IOException {
        if (val != null) {
            this.writer.write(' ');
            this.writer.write(name);
            this.writer.write("=\"");
            if (escape) {
                XML.escapeAttributeValue((String)val, (Writer)this.writer);
            } else {
                this.writer.write(val);
            }
            this.writer.write('\"');
        }
    }

    void startTag(String tag, String name, boolean closeTag) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write('<');
        this.writer.write(tag);
        if (name != null) {
            this.writeAttr("name", name);
            if (closeTag) {
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write('>');
        }
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("<result");
        this.writeAttr("name", name);
        this.writeAttr("numFound", Long.toString(numFound));
        this.writeAttr("start", Long.toString(start));
        if (maxScore != null) {
            this.writeAttr("maxScore", Float.toString(maxScore.floatValue()));
        }
        if (numFoundExact != null) {
            this.writeAttr("numFoundExact", numFoundExact.toString());
        }
        this.writer.write(">");
        this.incLevel();
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        this.startTag("doc", name, false);
        this.incLevel();
        for (String fname : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.wantsField(fname)) continue;
            Object val = doc.getFieldValue(fname);
            if ("_explain_".equals(fname) && log.isDebugEnabled()) {
                log.debug(String.valueOf(val));
            }
            this.writeVal(fname, val, this.shouldWriteRaw(fname, returnFields));
        }
        if (doc.hasChildDocuments()) {
            for (SolrDocument childDoc : doc.getChildDocuments()) {
                this.writeSolrDocument(null, childDoc, new SolrReturnFields(), idx);
            }
        }
        this.decLevel();
        this.writer.write("</doc>");
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</result>");
    }

    public void writeNamedList(String name, NamedList<?> val) throws IOException {
        int sz = val.size();
        this.startTag("lst", name, sz <= 0);
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            this.writeVal(val.getName(i), val.getVal(i));
        }
        this.decLevel();
        if (sz > 0) {
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</lst>");
        }
    }

    public void writeMap(String name, MapWriter val) throws IOException {
        this.startTag("lst", name, false);
        this.incLevel();
        val.writeMap(new MapWriter.EntryWriter(){

            public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
                XMLWriter.this.writeVal(null == k ? null : k.toString(), v);
                return this;
            }
        });
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</lst>");
    }

    public void writeMap(String name, Map<?, ?> map, boolean excludeOuter, boolean isFirstVal) throws IOException {
        int sz = map.size();
        if (!excludeOuter) {
            this.startTag("lst", name, sz <= 0);
            this.incLevel();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeVal(null == k ? null : k.toString(), v);
        }
        if (!excludeOuter) {
            this.decLevel();
            if (sz > 0) {
                if (this.doIndent) {
                    this.indent();
                }
                this.writer.write("</lst>");
            }
        }
    }

    public void writeArray(String name, Object[] val, boolean raw) throws IOException {
        this.writeArray(name, Arrays.asList(val).iterator(), raw);
    }

    public void writeArray(String name, Iterator<?> iter, boolean raw) throws IOException {
        if (iter.hasNext()) {
            this.startTag("arr", name, false);
            this.incLevel();
            while (iter.hasNext()) {
                this.writeVal(null, iter.next(), raw);
            }
            this.decLevel();
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</arr>");
        } else {
            this.startTag("arr", name, true);
        }
    }

    public void writeIterator(String name, IteratorWriter val, final boolean raw) throws IOException {
        this.startTag("arr", name, false);
        this.incLevel();
        val.writeIter(new IteratorWriter.ItemWriter(){

            public IteratorWriter.ItemWriter add(Object o) throws IOException {
                XMLWriter.this.writeVal(null, o, raw);
                return this;
            }
        });
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</arr>");
    }

    public void writeNull(String name) throws IOException {
        this.writePrim("null", name, "", false);
    }

    public void writeStrRaw(String name, String val) throws IOException {
        int contentLen = val == null ? 0 : val.length();
        this.startTag("raw", name, contentLen == 0);
        if (contentLen == 0) {
            return;
        }
        this.writer.write(val, 0, contentLen);
        this.writer.write("</raw>");
    }

    public void writeStr(String name, String val, boolean escape) throws IOException {
        this.writePrim("str", name, val, escape);
    }

    public void writeInt(String name, String val) throws IOException {
        this.writePrim("int", name, val, false);
    }

    public void writeLong(String name, String val) throws IOException {
        this.writePrim("long", name, val, false);
    }

    public void writeBool(String name, String val) throws IOException {
        this.writePrim("bool", name, val, false);
    }

    public void writeFloat(String name, String val) throws IOException {
        this.writePrim("float", name, val, false);
    }

    public void writeFloat(String name, float val) throws IOException {
        this.writeFloat(name, Float.toString(val));
    }

    public void writeDouble(String name, String val) throws IOException {
        this.writePrim("double", name, val, false);
    }

    public void writeDouble(String name, double val) throws IOException {
        this.writeDouble(name, Double.toString(val));
    }

    public void writeDate(String name, String val) throws IOException {
        this.writePrim("date", name, val, false);
    }

    private void writePrim(String tag, String name, String val, boolean escape) throws IOException {
        int contentLen = val == null ? 0 : val.length();
        this.startTag(tag, name, contentLen == 0);
        if (contentLen == 0) {
            return;
        }
        if (escape) {
            XML.escapeCharData((String)val, (Writer)this.writer);
        } else {
            this.writer.write(val, 0, contentLen);
        }
        this.writer.write('<');
        this.writer.write('/');
        this.writer.write(tag);
        this.writer.write('>');
    }
}

