/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.util.stats.MetricUtils;

public abstract class SolrPrometheusFormatter {
    protected final Map<String, List<CounterSnapshot.CounterDataPointSnapshot>> metricCounters = new HashMap<String, List<CounterSnapshot.CounterDataPointSnapshot>>();
    protected final Map<String, List<GaugeSnapshot.GaugeDataPointSnapshot>> metricGauges = new HashMap<String, List<GaugeSnapshot.GaugeDataPointSnapshot>>();
    protected final Map<String, List<SummarySnapshot.SummaryDataPointSnapshot>> metricSummaries = new HashMap<String, List<SummarySnapshot.SummaryDataPointSnapshot>>();

    public abstract void exportDropwizardMetric(Metric var1, String var2);

    public abstract SolrMetric categorizeMetric(Metric var1, String var2);

    public void exportMeter(String metricName, Meter dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportCounter(String metricName, Counter dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportTimer(String metricName, Timer dropwizardMetric, Labels labels) {
        Snapshot snapshot = dropwizardMetric.getSnapshot();
        long count = snapshot.size();
        double sum = Arrays.stream(snapshot.getValues()).asDoubleStream().map(num -> MetricUtils.nsToMs(num)).sum();
        Quantiles quantiles = Quantiles.of(List.of(new Quantile(0.5, MetricUtils.nsToMs(snapshot.getMedian())), new Quantile(0.75, MetricUtils.nsToMs(snapshot.get75thPercentile())), new Quantile(0.99, MetricUtils.nsToMs(snapshot.get99thPercentile())), new Quantile(0.999, MetricUtils.nsToMs(snapshot.get999thPercentile()))));
        SummarySnapshot.SummaryDataPointSnapshot summary = new SummarySnapshot.SummaryDataPointSnapshot(count, sum, quantiles, labels, Exemplars.EMPTY, 0L);
        this.collectSummaryDatapoint(metricName, summary);
    }

    public void exportTimerCount(String metricName, Timer dropwizardMetric, Labels labels) {
        CounterSnapshot.CounterDataPointSnapshot dataPoint = this.createCounterDatapoint(dropwizardMetric.getCount(), labels);
        this.collectCounterDatapoint(metricName, dataPoint);
    }

    public void exportGauge(String metricName, Gauge<?> dropwizardMetricRaw, Labels labels) {
        Object dropwizardMetric = dropwizardMetricRaw.getValue();
        if (dropwizardMetric instanceof Number) {
            GaugeSnapshot.GaugeDataPointSnapshot dataPoint = this.createGaugeDatapoint(((Number)dropwizardMetric).doubleValue(), labels);
            this.collectGaugeDatapoint(metricName, dataPoint);
        } else if (dropwizardMetric instanceof HashMap) {
            HashMap itemsMap = (HashMap)dropwizardMetric;
            for (Object item : itemsMap.keySet()) {
                if (!(itemsMap.get(item) instanceof Number)) continue;
                GaugeSnapshot.GaugeDataPointSnapshot dataPoint = this.createGaugeDatapoint(((Number)itemsMap.get(item)).doubleValue(), labels.merge(Labels.of((String[])new String[]{"item", (String)item})));
                this.collectGaugeDatapoint(metricName, dataPoint);
            }
        }
    }

    public CounterSnapshot.CounterDataPointSnapshot createCounterDatapoint(double value, Labels labels) {
        return ((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().value(value).labels(labels)).build();
    }

    public GaugeSnapshot.GaugeDataPointSnapshot createGaugeDatapoint(double value, Labels labels) {
        return ((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().value(value).labels(labels)).build();
    }

    public void collectCounterDatapoint(String metricName, CounterSnapshot.CounterDataPointSnapshot dataPoint) {
        if (!this.metricCounters.containsKey(metricName)) {
            this.metricCounters.put(metricName, new ArrayList());
        }
        this.metricCounters.get(metricName).add(dataPoint);
    }

    public void collectGaugeDatapoint(String metricName, GaugeSnapshot.GaugeDataPointSnapshot dataPoint) {
        if (!this.metricGauges.containsKey(metricName)) {
            this.metricGauges.put(metricName, new ArrayList());
        }
        this.metricGauges.get(metricName).add(dataPoint);
    }

    public void collectSummaryDatapoint(String metricName, SummarySnapshot.SummaryDataPointSnapshot dataPoint) {
        this.metricSummaries.computeIfAbsent(metricName, k -> new ArrayList()).add(dataPoint);
    }

    public MetricSnapshots collect() {
        ArrayList snapshots = new ArrayList();
        this.metricCounters.entrySet().forEach(entry -> snapshots.add(new CounterSnapshot(new MetricMetadata((String)entry.getKey()), (Collection)entry.getValue())));
        this.metricGauges.entrySet().forEach(entry -> snapshots.add(new GaugeSnapshot(new MetricMetadata((String)entry.getKey()), (Collection)entry.getValue())));
        this.metricSummaries.entrySet().forEach(entry -> snapshots.add(new SummarySnapshot(new MetricMetadata((String)entry.getKey()), (Collection)entry.getValue())));
        return new MetricSnapshots(snapshots);
    }
}

