/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.locale;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.locale.LocaleUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import java.util.Locale;

public final class PythonLocale {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(PythonLocale.class);
    public static final int LC_ALL = 6;
    public static final int LC_COLLATE = 3;
    public static final int LC_CTYPE = 0;
    public static final int LC_MESSAGES = 5;
    public static final int LC_MONETARY = 4;
    public static final int LC_NUMERIC = 1;
    public static final int LC_TIME = 2;
    private final Locale displayLocale;
    private final Locale formatLocale;

    public PythonLocale(Locale displayLocale, Locale formatLocale) {
        assert (displayLocale != null);
        assert (formatLocale != null);
        this.displayLocale = displayLocale;
        this.formatLocale = formatLocale;
    }

    public Locale category(int category) {
        return switch (category) {
            case 0, 3, 5 -> this.formatLocale;
            default -> this.displayLocale;
        };
    }

    public PythonLocale withCategory(int category, Locale locale) {
        return switch (category) {
            case 0, 3, 5 -> new PythonLocale(this.displayLocale, locale);
            case 1, 2, 4 -> new PythonLocale(locale, this.formatLocale);
            default -> new PythonLocale(locale, locale);
        };
    }

    public static PythonLocale initializeFromTruffleEnv(TruffleLanguage.Env env) {
        String defaultLangOption = (String)env.getOptions().get(PythonOptions.InitialLocale);
        if (defaultLangOption == null || defaultLangOption.isEmpty()) {
            return PythonLocale.fromJavaDefault();
        }
        Locale displayLocale = LocaleUtils.fromPosix(defaultLangOption, null);
        if (displayLocale == null) {
            LOGGER.warning(() -> "Could not parse the value of --python.InitialLocale='" + defaultLangOption + "'");
            return PythonLocale.fromJavaDefault();
        }
        LOGGER.fine(() -> "Selected locale: " + String.valueOf(displayLocale));
        return new PythonLocale(displayLocale, displayLocale);
    }

    public static PythonLocale fromJavaDefault() {
        Locale display = Locale.getDefault(Locale.Category.DISPLAY);
        Locale format = Locale.getDefault(Locale.Category.FORMAT);
        PythonLocale result = new PythonLocale(display, format);
        LOGGER.fine(() -> "Selected locale from Java default: " + String.valueOf(display) + ", " + String.valueOf(format));
        return result;
    }

    public void setAsJavaDefault() {
        CompilerAsserts.neverPartOfCompilation();
        Locale.setDefault(Locale.Category.DISPLAY, this.displayLocale);
        Locale.setDefault(Locale.Category.FORMAT, this.formatLocale);
    }
}

