/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=PythonBufferAcquireLibrary.class)})
public final class PBytes
extends PBytesLike {
    public PBytes(Object cls, Shape instanceShape, byte[] bytes) {
        super(PythonUtils.builtinClassToType(cls), instanceShape, bytes);
    }

    public PBytes(Object cls, Shape instanceShape, SequenceStorage store) {
        super(PythonUtils.builtinClassToType(cls), instanceShape, store);
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.store instanceof ByteSequenceStorage) {
            return BytesUtils.bytesRepr(((ByteSequenceStorage)this.store).getInternalByteArray(), this.store.length());
        }
        return this.store.toString();
    }

    @ExportMessage
    public static boolean isArrayElementModifiable(PBytes self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementInsertable(PBytes self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementRemovable(PBytes self, long index) {
        return false;
    }

    @ExportMessage
    public static void writeArrayElement(PBytes self, long key, Object value) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static void removeArrayElement(PBytes self, long key) throws UnsupportedMessageException, InvalidArrayIndexException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    Object acquire(int flags, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
        if ((flags & 1) != 0) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.BufferError, ErrorMessages.OBJ_IS_NOT_WRITABLE);
        }
        return this;
    }
}

