/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public class CLIProgressMonitor
extends AbstractProgressMonitor {
    private ProgressTaskId taskId;
    private String title = "";
    private String customText = "";
    private Stopwatch lastUpdateTime;
    private Stopwatch startTime;

    public CLIProgressMonitor() {
        super(new CancelHandler());
    }

    @Override
    protected void doBeginTask() {
        if (!Utils.isStripEmpty(this.title)) {
            Logging.info(I18n.tr("Beginning task {2}: {0}{1}", this.title, this.customText, Optional.ofNullable(this.taskId).map(ProgressTaskId::getId).map(id -> " " + id).orElse("")));
        }
        this.lastUpdateTime = this.startTime = Stopwatch.createStarted();
    }

    @Override
    protected void doFinishTask() {
        Logging.info(I18n.tr("Finishing task {2}: {0}{1} ({3})", this.title, this.customText, Optional.ofNullable(this.taskId).map(ProgressTaskId::getId).map(id -> " " + id).orElse(""), this.startTime));
        this.lastUpdateTime = null;
    }

    @Override
    protected void doSetIntermediate(boolean value) {
    }

    @Override
    protected void doSetTitle(String title) {
        this.title = Optional.ofNullable(title).orElse("");
    }

    @Override
    protected void doSetCustomText(String customText) {
        this.customText = Optional.ofNullable(customText).map(str -> "/" + str).orElse("");
    }

    @Override
    protected void updateProgress(double value) {
        if (this.lastUpdateTime == null || this.lastUpdateTime.elapsed() > TimeUnit.SECONDS.toMillis(10L)) {
            this.lastUpdateTime = Stopwatch.createStarted();
            Logging.info(I18n.tr("Progress of task {2}: {0}{1} is {3}% ({4})", this.title, this.customText, Optional.ofNullable(this.taskId).map(ProgressTaskId::getId).map(id -> " " + id).orElse(""), value * 100.0, this.startTime));
        }
    }

    @Override
    public void setProgressTaskId(ProgressTaskId taskId) {
        this.taskId = taskId;
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return this.taskId;
    }

    @Override
    public Component getWindowParent() {
        return null;
    }
}

