/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.function.BiFunction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.Logging;

public final class StyleSettingFactory {
    private StyleSettingFactory() {
    }

    public static StyleSetting create(Cascade c, StyleSource parentStyle, String key) {
        String type = c.get("type", null, String.class);
        String qualifiedKey = String.join((CharSequence)":", parentStyle.url, type, key);
        switch (type) {
            case "boolean": {
                return StyleSettingFactory.forLabelAndDefault(c, Boolean.class, (label, defaultValue) -> {
                    BooleanProperty property = new BooleanProperty(qualifiedKey, (boolean)defaultValue);
                    return new StyleSetting.BooleanStyleSetting(parentStyle, (String)label, property);
                });
            }
            case "double": {
                return StyleSettingFactory.forLabelAndDefault(c, Double.class, (label, defaultValue) -> {
                    DoubleProperty property = new DoubleProperty(qualifiedKey, (double)defaultValue);
                    return new StyleSetting.PropertyStyleSetting<Double>(parentStyle, (String)label, Double.class, property);
                });
            }
            case "string": {
                return StyleSettingFactory.forLabelAndDefault(c, String.class, (label, defaultValue) -> {
                    StringProperty property = new StringProperty(qualifiedKey, (String)defaultValue);
                    return new StyleSetting.PropertyStyleSetting<String>(parentStyle, (String)label, String.class, property);
                });
            }
            case "color": {
                return StyleSettingFactory.forLabelAndDefault(c, Color.class, (label, defaultValue) -> {
                    NamedColorProperty property = new NamedColorProperty("mappaint", parentStyle.title == null ? "MapCSS" : parentStyle.title, (String)label, (Color)defaultValue);
                    return new StyleSetting.ColorStyleSetting(parentStyle, (String)label, property);
                });
            }
        }
        Logging.warn("Unknown setting type {0} for style {1}", type, parentStyle.url);
        return null;
    }

    private static <T> StyleSetting forLabelAndDefault(Cascade c, Class<T> type, BiFunction<String, T, StyleSetting> function) {
        String label = c.get("label", null, String.class);
        if (label == null) {
            Logging.warn("property 'label' required for style setting of type " + String.valueOf(type));
            return null;
        }
        Object defaultValue = c.get("default", null, type);
        if (defaultValue == null) {
            Logging.warn("property 'default' required for style setting of type " + String.valueOf(type));
            return null;
        }
        return function.apply(label, (String)defaultValue);
    }
}

