/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.CheckableComponentSpec;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.platform.base.component.internal.AbstractComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBuildableComponentSpec
extends AbstractComponentSpec
implements BuildableComponentSpec,
CheckableComponentSpec {
    private final DefaultTaskDependency buildTaskDependencies = new DefaultTaskDependency();
    private Task buildTask;
    private final DefaultTaskDependency checkTaskDependencies = new DefaultTaskDependency();
    private Task checkTask;

    public AbstractBuildableComponentSpec(ComponentSpecIdentifier identifier, Class<? extends BuildableComponentSpec> publicType) {
        super(identifier, publicType);
    }

    @Override
    public @Nullable Task getBuildTask() {
        return this.buildTask;
    }

    @Override
    public void setBuildTask(@Nullable Task buildTask) {
        this.buildTask = buildTask;
        if (buildTask != null) {
            buildTask.dependsOn(new Object[]{this.buildTaskDependencies});
        }
    }

    public TaskDependency getBuildDependencies() {
        TaskDependencyFactory taskDependencyFactory = DefaultTaskDependencyFactory.withNoAssociatedProject();
        return taskDependencyFactory.visitingDependencies(context -> {
            if (this.buildTask == null) {
                context.add((Object)this.buildTaskDependencies);
            } else {
                context.add((Object)this.buildTask);
            }
        });
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildTaskDependencies.add(tasks);
    }

    @Override
    public boolean hasBuildDependencies() {
        return this.buildTaskDependencies.getDependenciesForInternalUse(this.buildTask).size() > 0;
    }

    @Override
    public @Nullable Task getCheckTask() {
        return this.checkTask;
    }

    @Override
    public void setCheckTask(@Nullable Task checkTask) {
        this.checkTask = checkTask;
        if (checkTask != null) {
            checkTask.dependsOn(new Object[]{this.checkTaskDependencies});
        }
    }

    @Override
    public void checkedBy(Object ... tasks) {
        this.checkTaskDependencies.add(tasks);
    }
}

