﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/Omics_EXPORTS.h>
#include <aws/omics/model/JobStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Omics {
namespace Model {

/**
 * <p>Details about an imported annotation item.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AnnotationImportItemDetail">AWS
 * API Reference</a></p>
 */
class AnnotationImportItemDetail {
 public:
  AWS_OMICS_API AnnotationImportItemDetail() = default;
  AWS_OMICS_API AnnotationImportItemDetail(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API AnnotationImportItemDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The source file's location in Amazon S3.</p>
   */
  inline const Aws::String& GetSource() const { return m_source; }
  inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }
  template <typename SourceT = Aws::String>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = Aws::String>
  AnnotationImportItemDetail& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The item's job status.</p>
   */
  inline JobStatus GetJobStatus() const { return m_jobStatus; }
  inline bool JobStatusHasBeenSet() const { return m_jobStatusHasBeenSet; }
  inline void SetJobStatus(JobStatus value) {
    m_jobStatusHasBeenSet = true;
    m_jobStatus = value;
  }
  inline AnnotationImportItemDetail& WithJobStatus(JobStatus value) {
    SetJobStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_source;
  bool m_sourceHasBeenSet = false;

  JobStatus m_jobStatus{JobStatus::NOT_SET};
  bool m_jobStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Omics
}  // namespace Aws
