/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class FindLinksHandler {
    /*
     * Loose catch block
     */
    public static List<? extends Location> findLinks(String linkType, TextDocumentPositionParams position, IProgressMonitor monitor) {
        block6: {
            ITypeRoot unit;
            block5: {
                List<LinkLocation> list;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                unit = null;
                try {
                    JavaLanguageServerPlugin.getInstance();
                    PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
                    boolean returnCompilationUnit = preferenceManager == null ? false : preferenceManager.isClientSupportsClassFileContent() && preferenceManager.getPreferences().isIncludeDecompiledSources();
                    unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri(), returnCompilationUnit, monitor);
                    if (unit == null || monitor.isCanceled()) break block5;
                    IJavaElement element = JDTUtils.findElementAtSelection(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), preferenceManager, monitor);
                    if (monitor.isCanceled() || !Objects.equals(linkType, "superImplementation")) break block5;
                    IMethod overriddenMethod = FindLinksHandler.findOverriddenMethod(element, monitor);
                    if (monitor.isCanceled() || overriddenMethod == null) break block5;
                    Location location = NavigateToDefinitionHandler.computeDefinitionNavigation((IJavaElement)overriddenMethod, element.getJavaProject());
                    if (monitor.isCanceled() || location == null) break block5;
                    String declaringTypeName = overriddenMethod.getDeclaringType().getFullyQualifiedName();
                    String methodName = overriddenMethod.getElementName();
                    String displayName = declaringTypeName + "." + methodName;
                    list = Collections.singletonList(new LinkLocation(displayName, "method", location));
                }
                catch (JavaModelException javaModelException) {
                    JDTUtils.discardClassFileWorkingCopy(unit);
                    break block6;
                    catch (Throwable throwable) {
                        JDTUtils.discardClassFileWorkingCopy(unit);
                        throw throwable;
                    }
                }
                JDTUtils.discardClassFileWorkingCopy(unit);
                return list;
            }
            JDTUtils.discardClassFileWorkingCopy(unit);
        }
        return Collections.emptyList();
    }

    public static IMethod findOverriddenMethod(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        if (!(element instanceof IMethod)) {
            return null;
        }
        IMethod method = (IMethod)element;
        IType type = method.getDeclaringType();
        if (type == null || type.isInterface() || method.isConstructor()) {
            return null;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(monitor);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IMethod found = tester.findOverriddenMethod(method, true);
        if (found != null && !found.equals(method)) {
            return found;
        }
        return null;
    }

    public static class FindLinksParams {
        public String type;
        public TextDocumentPositionParams position;
    }

    public static class LinkLocation
    extends Location {
        public String displayName;
        public String kind;

        public LinkLocation(String displayName, String kind, Location location) {
            super(location.getUri(), location.getRange());
            this.displayName = displayName;
            this.kind = kind;
        }
    }
}

