/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.core.nature.RcpttNature;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.wizards.LocationSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class WizardExecutablePage
extends WizardPage {
    private final IStructuredSelection initialSelection;
    private Text locationText;
    protected String location;

    public WizardExecutablePage(String pageName, String title, IStructuredSelection selection) {
        super(pageName, title, null);
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.WizardExecutablePage_LocationLabel);
        this.locationText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.locationText);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardExecutablePage.this.location = WizardExecutablePage.this.locationText.getText();
                WizardExecutablePage.this.validate();
            }
        });
        Button browse = new Button(composite, 8);
        browse.setText(Messages.WizardExecutablePage_BrowseButton);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardExecutablePage.this.browseLocation();
            }
        });
        this.setButtonLayoutData(browse);
        this.createContent(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setInitialSelection();
        this.validate();
    }

    protected void browseLocation() {
        LocationSelectionDialog dialog = new LocationSelectionDialog(this.getShell());
        dialog.setLocation(this.location);
        if (dialog.open() == 0) {
            this.location = dialog.getLocation();
            this.locationText.setText(this.location);
            this.validate();
        }
    }

    protected void setInitialSelection() {
        Iterator it = this.initialSelection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible() && selectedResource instanceof IContainer) {
                    this.location = selectedResource.getFullPath().toString();
                    this.locationText.setText(this.location);
                }
            }
        }
    }

    protected abstract void createContent(Composite var1);

    protected void validate() {
        boolean valid = this.doValidate();
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(this.getDefaultMessage());
        }
        this.setPageComplete(valid);
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    protected String getDefaultMessage() {
        return null;
    }

    protected boolean doValidate() {
        this.setErrorMessage(null);
        if (this.location != null) {
            IFolder folder;
            Path containerPath = new Path(this.location);
            IProject project = this.getProject();
            if (project == null || !Path.EMPTY.isValidPath(containerPath.toString())) {
                this.setErrorMessage(Messages.WizardExecutablePage_EmptyParentMsg);
                return false;
            }
            IPath path = containerPath.removeFirstSegments(1);
            if (!path.isEmpty() && !(folder = project.getFolder(path)).exists()) {
                this.setErrorMessage(Messages.WizardExecutablePage_NotExistingFolderMsg);
                return false;
            }
        } else {
            this.setErrorMessage(Messages.WizardExecutablePage_EmptyParentMsg);
            return false;
        }
        return true;
    }

    public IProject getProject() {
        Path resourcePath = new Path(this.location);
        if (resourcePath == null || resourcePath.segmentCount() <= 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.segment(0));
        try {
            if (RcpttNature.isRcpttProject((IProject)project)) {
                return project;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IPath getPathInProject() {
        return new Path(this.location).removeFirstSegments(1);
    }
}

