/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.ApplicationSelectionDialog;
import org.eclipse.pde.internal.ui.launcher.LaunchAction;
import org.eclipse.pde.ui.launcher.AbstractLaunchShortcut;
import org.eclipse.ui.IEditorPart;
import org.osgi.resource.Resource;

public class EclipseLaunchShortcut
extends AbstractLaunchShortcut {
    public static final String CONFIGURATION_TYPE = "org.eclipse.pde.ui.RuntimeWorkbench";
    private IPluginModelBase fModel = null;
    private String fApplicationName = null;

    public void launch(IEditorPart editor, String mode) {
        this.fApplicationName = null;
        this.fModel = null;
        this.launch(mode);
    }

    public void launch(ISelection selection, String mode) {
        IStructuredSelection ssel;
        IPluginModelBase model = null;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            Object object = ssel.getFirstElement();
            IProject project = null;
            if (object instanceof IFile) {
                if ("product".equals(((IFile)object).getFileExtension())) {
                    WorkspaceProductModel productModel = new WorkspaceProductModel((IFile)object, false);
                    try {
                        productModel.load();
                        new LaunchAction(productModel.getProduct(), ((IFile)object).getFullPath(), mode).run();
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                    return;
                }
                project = ((IFile)object).getProject();
            } else if (object instanceof IAdaptable) {
                project = (IProject)((IAdaptable)object).getAdapter(IProject.class);
            }
            if (project != null && project.isOpen()) {
                model = PluginRegistry.findModel((IProject)project);
            }
        }
        this.launch(model, mode);
    }

    private void launch(IPluginModelBase model, String mode) {
        this.fModel = model;
        this.fApplicationName = null;
        if (this.fModel != null) {
            ApplicationSelectionDialog dialog;
            String[] applicationNames = this.getAvailableApplications();
            if (applicationNames.length == 1) {
                this.fApplicationName = applicationNames[0];
            } else if (applicationNames.length > 1 && (dialog = new ApplicationSelectionDialog(PDEPlugin.getActiveWorkbenchShell().getShell(), applicationNames, mode)).open() == 0) {
                this.fApplicationName = dialog.getSelectedApplication();
            }
        }
        this.launch(mode);
    }

    @Override
    protected ILaunchConfiguration findLaunchConfiguration(String mode) {
        ILaunchConfiguration config = super.findLaunchConfiguration(mode);
        if (config != null) {
            try {
                if (!config.getAttribute("default", false) && config.getAttribute("pde.generated.config", false)) {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    this.initializePluginsList(wc);
                    return wc.doSave();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return config;
    }

    private String[] getAvailableApplications() {
        IPluginBase plugin = this.fModel.getPluginBase();
        String id = plugin.getId();
        if (id == null || id.trim().length() == 0) {
            return new String[0];
        }
        IPluginExtension[] extensions = plugin.getExtensions();
        ArrayList<String> result = new ArrayList<String>();
        IPluginExtension[] iPluginExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionID;
            IPluginExtension extension = iPluginExtensionArray[n2];
            if ("org.eclipse.core.runtime.applications".equals(extension.getPoint()) && (extensionID = extension.getId()) != null) {
                result.add(IdUtil.getFullId((IPluginExtension)extension));
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private String getProduct(String appName) {
        if (appName == null) {
            return TargetPlatform.getDefaultProduct();
        }
        if (this.fModel != null) {
            IPluginExtension[] extensions;
            IPluginExtension[] iPluginExtensionArray = extensions = this.fModel.getPluginBase().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginAttribute attr;
                IPluginElement prod;
                IPluginExtension ext = iPluginExtensionArray[n2];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product") && (attr = prod.getAttribute("application")) != null && appName.equals(attr.getValue())) {
                    return IdUtil.getFullId((IPluginExtension)ext);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    protected boolean isGoodMatch(ILaunchConfiguration configuration) {
        try {
            if (!configuration.getAttribute("useProduct", false)) {
                String configApp = configuration.getAttribute("application", null);
                return configApp == null && this.fApplicationName == null || this.fApplicationName != null && this.fApplicationName.equals(configApp);
            }
            String thisProduct = configuration.getAttribute("product", null);
            return thisProduct != null && thisProduct.equals(this.getProduct(this.fApplicationName));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    protected void initializeConfiguration(ILaunchConfigurationWorkingCopy wc) {
        if (TargetPlatformHelper.usesNewApplicationModel()) {
            wc.setAttribute("pde.version", "3.3");
        } else if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
            wc.setAttribute("pde.version", "3.2a");
        }
        wc.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)wc.getName()));
        this.initializeProgramArguments(wc);
        this.initializeVMArguments(wc);
        wc.setAttribute("clearws", false);
        wc.setAttribute("askclear", true);
        wc.setAttribute("append.args", true);
        wc.setAttribute("checked", "[NONE]");
        wc.setAttribute("automaticValidate", true);
        wc.setAttribute("default", this.fApplicationName == null);
        if (this.fApplicationName != null) {
            String product = this.getProduct(this.fApplicationName);
            if (product == null) {
                wc.setAttribute("application", this.fApplicationName);
            } else {
                wc.setAttribute("useProduct", true);
                wc.setAttribute("product", product);
            }
            wc.setAttribute("automaticAdd", true);
        } else {
            String defaultProduct = TargetPlatform.getDefaultProduct();
            if (defaultProduct != null) {
                wc.setAttribute("default", true);
                wc.setAttribute("useProduct", true);
                wc.setAttribute("product", defaultProduct);
            }
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
    }

    private void initializeProgramArguments(ILaunchConfigurationWorkingCopy wc) {
        String programArgs = LaunchArgumentsHelper.getInitialProgramArguments();
        if (programArgs.length() > 0) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
        }
    }

    private void initializeVMArguments(ILaunchConfigurationWorkingCopy wc) {
        String vmArgs = LaunchArgumentsHelper.getInitialVMArguments();
        if (vmArgs.length() > 0) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
    }

    @Override
    protected String getLaunchConfigurationTypeName() {
        return CONFIGURATION_TYPE;
    }

    @Override
    protected String getName(ILaunchConfigurationType type) {
        if (this.fApplicationName == null) {
            return super.getName(type);
        }
        String product = this.getProduct(this.fApplicationName);
        return product == null ? this.fApplicationName : product;
    }

    private void initializePluginsList(ILaunchConfigurationWorkingCopy wc) {
        HashSet<String> wsplugins = new HashSet<String>();
        HashSet<String> explugins = new HashSet<String>();
        Set plugins = DependencyManager.getSelfAndDependencies(Set.of(this.fModel));
        for (Resource plugin : plugins) {
            IPluginModelBase model = PluginRegistry.findModel((Resource)plugin);
            if (model == null || !model.isEnabled()) continue;
            if (model.getUnderlyingResource() == null) {
                this.appendPlugin(explugins, model);
                continue;
            }
            this.appendPlugin(wsplugins, model);
        }
        wc.setAttribute("selected_workspace_bundles", wsplugins);
        wc.setAttribute("selected_target_bundles", explugins);
    }

    private void appendPlugin(Set<String> plugins, IPluginModelBase model) {
        StringBuilder builder = new StringBuilder();
        builder.append(model.getPluginBase().getId());
        builder.append('*');
        builder.append(model.getPluginBase().getVersion());
        plugins.add(builder.toString());
    }
}

