/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class ExternalFileTargetHandle
extends AbstractTargetHandle {
    static final String SCHEME = "file";
    private final URI fURI;
    private final File fFile;

    static ITargetHandle restoreHandle(URI uri) {
        return new ExternalFileTargetHandle(uri);
    }

    protected ExternalFileTargetHandle(URI uri) {
        this.fURI = uri;
        this.fFile = URIUtil.toFile((URI)this.fURI);
    }

    @Override
    void delete() throws CoreException {
    }

    @Override
    protected InputStream getInputStream() throws CoreException {
        try {
            return this.fURI.toURL().openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    void doSave(ITargetDefinition definition) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.fFile));){
                ((TargetDefinition)definition).write(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.LocalTargetHandle_4, (Object)this.fFile.getName()), (Throwable)e));
        }
    }

    @Override
    public boolean exists() {
        return this.fFile != null && this.fFile.exists();
    }

    @Override
    public String getMemento() throws CoreException {
        return this.fURI.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalFileTargetHandle) {
            ExternalFileTargetHandle target = (ExternalFileTargetHandle)obj;
            return target.getLocation().equals(this.fURI);
        }
        return super.equals(obj);
    }

    public URI getLocation() {
        return this.fURI;
    }

    public String toString() {
        return this.fURI.toString();
    }
}

