/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.CompareElementsEditor;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class CompareElementsDiffView
extends EditorPart
implements IEditorInput {
    private List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
    private List<String> objectNames = new ArrayList<String>();
    private List<String> fieldNames;
    private String elementTypeName;
    private Font fnt1;
    private Font fnt2;
    private FontData fntData;
    private String size;
    private String refType;
    public Text fText;
    private ILaunchesListener2 fLaunchesListener;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridLayout topLayout = new GridLayout();
        GridData data = new GridData();
        topLayout.numColumns = 1;
        topLayout.verticalSpacing = 20;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)data);
        Display display = Display.getDefault();
        Label l = new Label(parent, 0);
        this.fntData = new FontData("Arial", 17, 1);
        this.fnt1 = new Font((Device)parent.getDisplay(), this.fntData);
        l.setText("\n" + DebugUIMessages.ComparisionMultiHeader);
        l.setFont(this.fnt1);
        l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Color rowColor = null;
        Color cellColor = null;
        Table table = new Table(parent, 67584);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fntData = new FontData("Arial", 17, 0);
        this.fnt2 = new Font((Device)parent.getDisplay(), this.fntData);
        table.setFont(this.fnt2);
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        List<String> headers = this.headerSelection(this.elementTypeName);
        for (String header : headers) {
            TableColumn column = new TableColumn(table, 1);
            column.setText(header);
            column.setWidth(200);
            column.setResizable(true);
            column.setAlignment(0x1000000);
        }
        int i = 0;
        while (i < this.results.size()) {
            Map<String, Object> temp = this.results.get(i);
            TableItem row = new TableItem(table, 0);
            Map contentsToShow = (Map)temp.get(this.objectNames.get(i));
            Object elements = "";
            if (contentsToShow.containsKey("Element Size")) {
                this.size = contentsToShow.get("Element Size").toString();
            }
            if (contentsToShow.containsKey("Type")) {
                this.refType = contentsToShow.get("Type").toString();
            }
            if (this.elementTypeName.equals("Sets") || this.elementTypeName.equals("Lists") || this.elementTypeName.equals("Arrays") || this.elementTypeName.equals("Queues") || this.elementTypeName.equals("Deques") || this.elementTypeName.equals("Iterables")) {
                if (!contentsToShow.containsKey("Values") && contentsToShow.containsKey("ImmediateResult")) {
                    elements = contentsToShow.get("ImmediateResult").toString();
                    rowColor = display.getSystemColor(6);
                } else if (contentsToShow.containsKey("Values")) {
                    String missingValExtracted = contentsToShow.get("MultiValues").toString();
                    elements = "Missing contents from ";
                    elements = (String)elements + missingValExtracted.substring(1, missingValExtracted.length() - 1);
                    elements = ((String)elements).replace('[', '{');
                    elements = ((String)elements).replace(']', '}');
                    elements = ((String)elements).replace("=", "-");
                    rowColor = display.getSystemColor(4);
                } else {
                    elements = "Contains every element of others";
                    rowColor = display.getSystemColor(6);
                }
                int count = i + 1;
                String SlNo = "\t " + count;
                elements = this.replaceToSingular((String)elements);
                row.setText(new String[]{SlNo, this.objectNames.get(i), elements, this.size, this.refType});
                row.setBackground(rowColor);
                row.setForeground(display.getSystemColor(1));
            } else if (this.elementTypeName.equals("CharSequences")) {
                elements = contentsToShow.get("ImmediateResult").toString();
                rowColor = ((String)elements).contains("Same") ? display.getSystemColor(6) : display.getSystemColor(4);
                int count = i + 1;
                String SlNo = "\t " + count;
                row.setText(new String[]{SlNo, this.objectNames.get(i), elements, this.size, this.refType});
                row.setBackground(rowColor);
                row.setForeground(display.getSystemColor(1));
            } else if (this.elementTypeName.equals("Maps")) {
                Object forKey = null;
                Object forVal = null;
                if (contentsToShow.containsKey("keySameInfo")) {
                    forKey = contentsToShow.get("keySameInfo").toString();
                    rowColor = display.getSystemColor(6);
                }
                if (contentsToShow.containsKey("valSameInfo")) {
                    forVal = contentsToShow.get("valSameInfo").toString();
                    rowColor = display.getSystemColor(6);
                }
                if (contentsToShow.containsKey("MapValues")) {
                    String missingValExtracted = contentsToShow.get("MultiMapValues").toString();
                    forVal = "Missing values : " + missingValExtracted.substring(1, missingValExtracted.length() - 1);
                    rowColor = display.getSystemColor(4);
                }
                if (contentsToShow.containsKey("MapKeys")) {
                    String missingKeyExtracted = contentsToShow.get("MultiMapKeys").toString();
                    forKey = "Missing keys : " + missingKeyExtracted.substring(1, missingKeyExtracted.length() - 1);
                    rowColor = display.getSystemColor(4);
                }
                if (forVal == null) {
                    forVal = "Contains every value of others";
                }
                if (forKey == null) {
                    forKey = "Contains every key of others";
                }
                int count = i + 1;
                SlNo = "\t " + count;
                row.setText(new String[]{SlNo, this.objectNames.get(i), forKey, forVal, this.size, this.refType});
                row.setBackground(rowColor);
                if (((String)forVal).contains("Contains")) {
                    cellColor = display.getSystemColor(6);
                    row.setBackground(3, cellColor);
                }
                if (((String)forKey).contains("Contains")) {
                    cellColor = display.getSystemColor(6);
                    row.setBackground(2, cellColor);
                }
                if (((String)forKey).contains("Contains") && ((String)forVal).contains("Contains")) {
                    row.setBackground(cellColor);
                }
                row.setForeground(display.getSystemColor(1));
            } else if (this.elementTypeName.equals("custom")) {
                String[] con = new String[this.fieldNames.size()];
                if (contentsToShow.containsKey("fields")) {
                    Map field = (Map)contentsToShow.get("fields");
                    int count = i + 1;
                    SlNo = "\t " + count;
                    con[0] = SlNo;
                    con[1] = this.objectNames.get(i);
                    int j = 2;
                    while (j < con.length) {
                        con[j] = (String)field.get(this.fieldNames.get(j));
                        cellColor = ((String)field.get(this.fieldNames.get(j))).contains("Same") && !((String)field.get(this.fieldNames.get(j))).contains("diffe") ? display.getSystemColor(6) : display.getSystemColor(4);
                        row.setBackground(j, cellColor);
                        ++j;
                    }
                    row.setText(con);
                    row.setBackground(cellColor);
                    row.setForeground(display.getSystemColor(1));
                } else {
                    int count = i + 1;
                    String SlNo = "\t " + count;
                    Set same = (Set)contentsToShow.get("REF_SAME");
                    Set diff = (Set)contentsToShow.get("REF_DIFF");
                    con[0] = SlNo;
                    con[1] = this.objectNames.get(i);
                    int j = 2;
                    while (j < con.length) {
                        if (!same.isEmpty()) {
                            cellColor = display.getSystemColor(6);
                            con[j] = NLS.bind((String)DebugUIMessages.ObjectsReferenceSameAndDifferent, (Object[])new Object[]{same.toString(), diff.toString()});
                        } else {
                            cellColor = display.getSystemColor(4);
                            con[j] = NLS.bind((String)DebugUIMessages.ObjectsReferenceDifferent, (Object)diff.toString());
                        }
                        ++j;
                    }
                    row.setText(con);
                    row.setBackground(cellColor);
                    row.setForeground(display.getSystemColor(1));
                }
            } else {
                elements = contentsToShow.get("ImmediateResult").toString();
                rowColor = ((String)elements).contains("Same") ? display.getSystemColor(6) : display.getSystemColor(4);
                int count = i + 1;
                String SlNo = "\t " + count;
                row.setText(new String[]{SlNo, this.objectNames.get(i), elements, this.refType});
                row.setBackground(rowColor);
                row.setForeground(display.getSystemColor(1));
            }
            ++i;
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        Dialog.applyDialogFont((Control)parent);
    }

    private List<String> headerSelection(String type) {
        if (type.equals("Sets") || type.equals("Lists") || type.equals("Arrays") || type.equals("Queues") || type.equals("Deques") || type.equals("Iterables")) {
            return List.of("\tSL No.", "Variable Name", "Results", "Size", "Type");
        }
        if (type.equals("Maps")) {
            return List.of("\tSL No.", "Variable Name", "Map Keys", "Map Values", "<K,V> Size", "Type");
        }
        if (type.equals("CharSequences")) {
            return List.of("\tSL No.", "Variable Name", "String Comparision Result", "Characters", "Type");
        }
        if (type.equals("custom")) {
            this.fieldNames.add(0, "Variable Name");
            this.fieldNames.add(0, "\tSL No.");
            return this.fieldNames;
        }
        return List.of("\tSL No.", "Variable Name", "Comparision Result", "Type");
    }

    private String replaceToSingular(String content) {
        if (content.contains("Sets")) {
            content = content.replace("Sets", "Set");
        }
        if (content.contains("Lists")) {
            content = content.replace("Lists", "List");
        }
        if (content.contains("Arrays")) {
            content = content.replace("Arrays", "Array");
        }
        if (content.contains("Queues")) {
            content = content.replace("Queues", "Queue");
        }
        if (content.contains("Deques")) {
            content = content.replace("Deques", "Deque");
        }
        if (content.contains("Iterables")) {
            content = content.replace("Iterables", "Iterable");
        }
        if (content.contains("Maps")) {
            content = content.replace("Maps", "Map");
        }
        if (content.contains("CharSequences")) {
            content = content.replace("CharSequences", "CharSequence");
        }
        return content;
    }

    public void setFocus() {
        if (this.fText != null) {
            this.fText.setFocus();
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        if (this.fText != null) {
            this.fText.setText(this.getText());
        }
        this.firePropertyChange(258);
        if (input instanceof CompareElementsEditor) {
            CompareElementsEditor inp2 = (CompareElementsEditor)input;
            this.results = inp2.results;
            this.objectNames = inp2.objectNames;
            this.elementTypeName = inp2.elementTypeName;
            this.fieldNames = inp2.fieldNames;
        }
    }

    protected String getText() {
        return this.getEditorInput().getName() + "\n";
    }

    protected void closeEditor() {
        this.dispose();
        CompareElementsDiffView editor = this;
        DebugUIPlugin.getStandardDisplay().syncExec(() -> CompareElementsDiffView.lambda$0((IEditorPart)editor));
    }

    public void dispose() {
        super.dispose();
        if (this.fnt1 != null && !this.fnt1.isDisposed()) {
            this.fnt1.dispose();
        }
        if (this.fnt2 != null && !this.fnt2.isDisposed()) {
            this.fnt2.dispose();
        }
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
        if (this.fLaunchesListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchesListener);
        }
    }

    protected void initialize() {
        this.fLaunchesListener = new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                Object artifact = CompareElementsDiffView.this.getArtifact();
                if (artifact instanceof IDebugElement) {
                    IDebugElement element = (IDebugElement)artifact;
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        if (launch.equals(element.getLaunch())) {
                            CompareElementsDiffView.this.closeEditor();
                            return;
                        }
                        ++n2;
                    }
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                this.launchesTerminated(launches);
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchesListener);
    }

    protected Object getArtifact() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof CompareElementsDiffView) {
            CompareElementsDiffView input = (CompareElementsDiffView)editorInput;
            return input.getArtifact();
        }
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    private static /* synthetic */ void lambda$0(IEditorPart iEditorPart) {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            activePage.closeEditor(iEditorPart, false);
        }
    }
}

