/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.ContextSnapshotAction;
import org.eclipse.rcptt.ui.context.ContextUIManager;
import org.eclipse.rcptt.ui.context.ContextViewer;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.rcptt.ui.wizards.WizardContextPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class NewContextWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardContextPage selectContextPage;
    private IContext context;
    private boolean takeSnapshot = false;
    private ContextType defaultType = null;

    public NewContextWizard() {
        this.setWindowTitle(Messages.NewContextWizard_WindowTitle);
    }

    public IContext getContext() {
        return this.context;
    }

    public void setTakeSnapshot(boolean snapshot) {
        this.takeSnapshot = snapshot;
    }

    public void setDefaultType(ContextType type) {
        this.defaultType = type;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.selectContextPage = new WizardContextPage(this.selection, this.defaultType);
        this.selectContextPage.setTakeSnapshot(this.takeSnapshot);
        this.addPage((IWizardPage)this.selectContextPage);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            IProject project = this.selectContextPage.getProject();
            ContextType type = this.selectContextPage.getContextType();
            String name = this.selectContextPage.getContextName();
            IPath containerPath = this.selectContextPage.getPathInProject();
            IQ7Folder folder = RcpttCore.create((IProject)project).getFolder(containerPath);
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(this.getShell());
            if (!writeAccessChecker.makeResourceWritable(folder.getResource())) {
                return false;
            }
            this.context = folder.createContext(name, type, true, (IProgressMonitor)new NullProgressMonitor());
            if (!this.takeSnapshot) {
                IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)((IFile)this.context.getResource()));
                return true;
            }
            ContextViewer viewer = ContextUIManager.getInstance().getViewer(type);
            IQ7NamedElement workingCopy = this.context.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                final IQ7Editor<Context> editor = viewer.getViewer().createEditor();
                editor.setElement(workingCopy);
                ContextSnapshotAction action = new ContextSnapshotAction(editor);
                action.setJoin(true);
                action.run();
                if (action.getStatus() == Status.CANCEL_STATUS) {
                    ResourcesPlugin.getWorkspace().getRoot().findMember(this.context.getPath()).delete(true, null);
                    return false;
                }
                IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        editor.save();
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
                    if (!writeAccessChecker.makeResourceWritable(new IQ7Element[]{workingCopy})) {
                        editor.dispose();
                        return false;
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e.getCause());
                    editor.dispose();
                    return true;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    workingCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                    return true;
                }
            }
            finally {
                workingCopy.discardWorkingCopy();
            }
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
            return false;
        }
    }

    private IWorkbenchPage getPage() {
        return this.workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public IProject getProject() {
        return this.selectContextPage.getProject();
    }
}

