/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.verification;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.CompositeNamedElementActions;
import org.eclipse.rcptt.ui.editors.IQ7Viewer2;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.verification.VerificationEditorPage;
import org.eclipse.rcptt.ui.verification.VerificationUIManager;
import org.eclipse.rcptt.ui.verification.VerificationViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.WorkbenchPart;

public class VerificationEditor
extends NamedElementEditor
implements IGotoMarker {
    private VerificationEditorPage page;
    private IEditorPart part;
    private VerificationType type;
    private NamedElementEditorActions.INamedElementActions verificationActions;

    public Verification getElement() {
        return (Verification)super.getElement();
    }

    protected void addPages() {
        VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(this.type);
        if (viewer != null && viewer.getViewer() instanceof IQ7Viewer2) {
            IQ7Viewer2 v2 = (IQ7Viewer2)viewer.getViewer();
            this.part = v2.createEditorPart();
            this.part.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (260 == propId) {
                        VerificationEditor.this.setPartName(((WorkbenchPart)VerificationEditor.this.part).getPartName());
                    }
                }
            });
            try {
                this.addPage(this.part, this.getEditorInput());
                this.setTitleImage(viewer.getIcon().createImage());
                this.setPartName(this.part.getTitle());
            }
            catch (PartInitException e) {
                Q7UIPlugin.log(e);
            }
            return;
        }
        try {
            this.page = new VerificationEditorPage(this);
            this.addPage((IFormPage)this.page);
        }
        catch (PartInitException e) {
            Q7UIPlugin.log(e);
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.page != null) {
            this.page.setFocus();
        }
        if (this.part != null) {
            this.part.setFocus();
        }
    }

    protected IFile getInputFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            IFile inputFile = this.getInputFile(input);
            if (inputFile == null) {
                throw new PartInitException(Messages.NamedElementEditor_InvalidInputType);
            }
            IQ7NamedElement iq7Element = (IQ7NamedElement)RcpttCore.create((IResource)inputFile);
            this.type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)iq7Element.getNamedElement());
            if (this.type == null) {
                throw new PartInitException(Messages.bind((String)Messages.VerificationEditor_EmptyVerificationType, (Object)this.getElement()));
            }
            VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(this.type);
            if (viewer != null && viewer.getViewer() instanceof IQ7Viewer2) {
                IQ7Viewer2 v2 = (IQ7Viewer2)viewer.getViewer();
                this.setEnableResourceTracking(v2.isEnableResourceTracking());
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        super.init(site, input);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.page != null) {
                this.page.save();
            }
            if (this.part != null) {
                this.part.doSave(monitor);
            } else {
                super.doSave(monitor);
            }
        }
        catch (CoreException e) {
            Q7UIPlugin.log(e);
        }
    }

    public void setEditorImage(Image img) {
        this.setTitleImage(img);
    }

    protected void createPages() {
        super.createPages();
        this.hideTabs();
    }

    @Override
    public void createActions() {
        CompositeNamedElementActions compositeActions = new CompositeNamedElementActions(new NamedElementEditorActions.INamedElementActions[]{this.page.getContent(), this.verificationActions}){

            @Override
            public void update() {
                VerificationEditor.this.updateEnablement();
            }
        };
        this.actions = new NamedElementEditorActions(compositeActions, this.getEditorSite().getActionBars());
    }

    public IEditorPart getEditor() {
        return this.part;
    }

    public void setVerificationActions(NamedElementEditorActions.INamedElementActions actions) {
        this.verificationActions = actions;
        this.createActions();
    }

    public void gotoMarker(IMarker marker) {
        IGotoMarker adapter = (IGotoMarker)this.page.getAdapter(IGotoMarker.class);
        if (adapter != null) {
            adapter.gotoMarker(marker);
        }
    }
}

