/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class ModernElementListSelectionDialog
extends ElementListSelectionDialog {
    private SearchControl searchCtrl;
    private Label fMessage;

    public ModernElementListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
    }

    protected Label createMessageArea(Composite composite) {
        Label msg;
        this.fMessage = msg = super.createMessageArea(composite);
        return msg;
    }

    protected void setListElements(Object[] elements) {
        super.setListElements(elements);
        if (elements == null || elements.length == 0) {
            this.handleEmptyList();
        } else {
            this.handleNonemptyList();
        }
    }

    protected void handleEmptyList() {
        super.handleEmptyList();
        this.searchCtrl.setEnabled(false);
    }

    protected void handleNonemptyList() {
        this.fMessage.setEnabled(true);
        this.searchCtrl.setEnabled(true);
        this.fFilteredList.setEnabled(true);
        this.updateOkState();
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText((Composite)parent.getShell());
        text.setVisible(false);
        GridDataFactory.fillDefaults().hint(0, 0).applyTo((Control)text);
        Composite cp = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(cp);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)cp);
        this.searchCtrl = new SearchControl(cp){

            @Override
            public void onCR() {
                Object[] elements = ModernElementListSelectionDialog.this.getSelectedElements();
                if (elements.length > 0) {
                    ModernElementListSelectionDialog.this.buttonPressed(0);
                }
            }
        };
        this.searchCtrl.setFilterText(this.getFilter() == null ? "" : this.getFilter());
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (ModernElementListSelectionDialog.this.fFilteredList != null) {
                    String value = ModernElementListSelectionDialog.this.searchCtrl.getFilterString();
                    if (!ModernElementListSelectionDialog.this.searchCtrl.getInitialText().equals(value)) {
                        boolean skipNormal = false;
                        IQ7NamedElement[] elements = Q7SearchCore.findById((String)value, (ISearchScope)new AllProjectScope(), (IProgressMonitor)new NullProgressMonitor());
                        if (elements.length > 0) {
                            skipNormal = true;
                            try {
                                ModernElementListSelectionDialog.this.fFilteredList.setFilter(elements[0].getElementName());
                            }
                            catch (Throwable e2) {
                                Q7UIPlugin.log(e2);
                                skipNormal = false;
                            }
                        }
                        if (!skipNormal) {
                            ModernElementListSelectionDialog.this.fFilteredList.setFilter(value);
                        }
                    }
                }
            }
        };
        this.searchCtrl.getFilterControl().addListener(24, listener);
        return this.searchCtrl.getFilterControl();
    }

    protected FilteredList createFilteredList(Composite parent) {
        super.createFilteredList(parent);
        this.searchCtrl.setSearchResultControl((Control)this.fFilteredList);
        return this.fFilteredList;
    }
}

