/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.core.ecl.core.model.GetQ7Information;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.Q7Information;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpClientManager;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.util.FileUtil;

public final class Q7LaunchUtils {
    private static String META_DIR = ".metadata";
    private static String CONFIG_DEFAULT_DIR = "${workspace_loc}/" + META_DIR + "/.plugins/org.eclipse.pde.core/";
    private static final String Q7_VARIABLES_KEY = "org.eclipse.rcptt.tesla.variables.q7.";
    public static final String Q7_CURRENT_TEST_VAR = "current_test";

    private Q7LaunchUtils() {
    }

    public static void verifyConnection(String host, int port) throws CoreException {
        block10: {
            ISession session = null;
            try {
                InetAddress byName = InetAddress.getByName(host);
                session = EclTcpClientManager.Instance.startClientSession(byName, port);
            }
            catch (IOException e) {
                throw new CoreException(Q7LaunchingPlugin.createStatus("Couldn't connect to AUT", e));
            }
            try {
                GetQ7Information information = Q7CoreFactory.eINSTANCE.createGetQ7Information();
                IPipe out = session.createPipe();
                IProcess process = session.execute((Command)information, null, out);
                try {
                    IStatus status = process.waitFor();
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching", e.getMessage(), (Throwable)e));
                }
                Object object = out.take((long)TeslaLimits.getAUTStartupTimeout());
                if (object instanceof Q7Information) {
                    Q7Information info = (Q7Information)object;
                    if (!info.isTeslaActive()) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus("Tesla is not activated"));
                    }
                    break block10;
                }
                throw new CoreException(Q7LaunchingPlugin.createStatus("Expect Q7Information but found: " + String.valueOf(object)));
            }
            finally {
                session.close();
            }
        }
    }

    public static String getConfigFilesLocation(ILaunchConfiguration config) {
        Object filesLocation = "";
        try {
            boolean useDefaultArea = config.getAttribute("useDefaultConfigArea", true);
            filesLocation = !useDefaultArea ? config.getAttribute("configLocation", "") : CONFIG_DEFAULT_DIR + config.getName() + "/";
            filesLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution((String)filesLocation);
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log(e);
        }
        return filesLocation;
    }

    public static File getWorkspaceMeta(ILaunchConfiguration config) {
        try {
            File meta;
            String wsFile = config.getAttribute("location", "");
            wsFile = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(wsFile);
            File file = new File(wsFile);
            if (file.exists() && (meta = new File(file, META_DIR)).exists()) {
                return meta;
            }
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log(e);
        }
        return null;
    }

    public static void deleteConfigFiles(ILaunchConfiguration config) {
        String configLocation = Q7LaunchUtils.getConfigFilesLocation(config);
        File configFolder = new File(configLocation);
        if (configFolder.exists()) {
            FileUtil.deleteFile((File)configFolder, (boolean)true);
        }
    }

    public static void setQ7Variable(SetQ7Features features, String name, String value) {
        if (value != null) {
            features.getFeatures().add((Object)String.format("%s%s=%s", Q7_VARIABLES_KEY, name, value));
        }
    }
}

