/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.ResourceLockAware;
import org.junit.jupiter.engine.execution.ExtensionContextSupplier;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.0")
public class NestedClassTestDescriptor
extends ClassBasedTestDescriptor {
    public static final String SEGMENT_TYPE = "nested-class";

    public NestedClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        super(uniqueId, testClass, DisplayNameUtils.createDisplayNameSupplierForNestedClass(enclosingInstanceTypes, testClass, configuration), configuration);
    }

    public final Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return NestedClassTestDescriptor.getEnclosingTestClasses(this.getParent().orElse(null));
    }

    @API(status=API.Status.INTERNAL, since="5.12")
    public static List<Class<?>> getEnclosingTestClasses(TestDescriptor parent) {
        if (parent instanceof ClassBasedTestDescriptor) {
            ClassBasedTestDescriptor parentClassDescriptor = (ClassBasedTestDescriptor)parent;
            ArrayList result = new ArrayList(parentClassDescriptor.getEnclosingTestClasses());
            result.add(parentClassDescriptor.getTestClass());
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    protected TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionContextSupplier extensionContext, ExtensionRegistry registry, JupiterEngineExecutionContext context) {
        MutableExtensionRegistry extensionRegistryForOuterInstanceCreation = parentExecutionContext.getExtensionRegistry();
        TestInstances outerInstances = parentExecutionContext.getTestInstancesProvider().getTestInstances(extensionRegistryForOuterInstanceCreation, context);
        return this.instantiateTestClass(Optional.of(outerInstances), registry, extensionContext);
    }

    @Override
    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator() {
        return ResourceLockAware.enclosingInstanceTypesDependentResourceLocksProviderEvaluator(this::getEnclosingTestClasses, (provider, enclosingInstanceTypes) -> provider.provideForNestedClass(enclosingInstanceTypes, this.getTestClass()));
    }
}

