/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.filetransfer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class ProxyURLStreamHandlerService
implements URLStreamHandlerService {
    private static final String SERVICE_CLASS_ATTRIBUTE = "serviceClass";
    private final IConfigurationElement configurationElement;
    private URLStreamHandlerService delegate;

    public ProxyURLStreamHandlerService(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    public URLConnection openConnection(URL u) throws IOException {
        return this.getDelegate().openConnection(u);
    }

    public void parseURL(URLStreamHandlerSetter realHandler, URL u, String spec, int start, int limit) {
        this.getDelegate().parseURL(realHandler, u, spec, start, limit);
    }

    public String toExternalForm(URL u) {
        return this.getDelegate().toExternalForm(u);
    }

    public boolean equals(URL u1, URL u2) {
        return this.getDelegate().equals(u1, u2);
    }

    public int getDefaultPort() {
        return this.getDelegate().getDefaultPort();
    }

    public InetAddress getHostAddress(URL u) {
        return this.getDelegate().getHostAddress(u);
    }

    public int hashCode(URL u) {
        return this.getDelegate().hashCode(u);
    }

    public boolean hostsEqual(URL u1, URL u2) {
        return this.getDelegate().hostsEqual(u1, u2);
    }

    public boolean sameFile(URL u1, URL u2) {
        return this.getDelegate().sameFile(u1, u2);
    }

    synchronized URLStreamHandlerService getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (URLStreamHandlerService)this.configurationElement.createExecutableExtension(SERVICE_CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                throw new IllegalStateException("can't create executable extension", e);
            }
        }
        return this.delegate;
    }
}

