/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;

public class ZipEntryStorage
extends PlatformObject
implements IStorage {
    private ZipFile fArchive;
    private ZipEntry fZipEntry;

    public ZipEntryStorage(ZipFile archive, ZipEntry entry) {
        this.setArchive(archive);
        this.setZipEntry(entry);
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.fArchive.getInputStream(this.getZipEntry());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 125, SourceLookupMessages.ZipEntryStorage_0, (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return IPath.fromOSString((String)this.fArchive.getName()).append(this.getZipEntry().getName());
    }

    public String getName() {
        int index = this.getZipEntry().getName().lastIndexOf(92);
        if (index == -1) {
            index = this.getZipEntry().getName().lastIndexOf(47);
        }
        if (index == -1) {
            return this.getZipEntry().getName();
        }
        return this.getZipEntry().getName().substring(index + 1);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setArchive(ZipFile archive) {
        this.fArchive = archive;
    }

    @Deprecated(forRemoval=true, since="3.22 (removal in 2026-12 or later)")
    public ZipFile getArchive() {
        return this.fArchive;
    }

    public Path getArchivePath() {
        return Path.of(this.fArchive.getName(), new String[0]);
    }

    private void setZipEntry(ZipEntry entry) {
        this.fZipEntry = entry;
    }

    public ZipEntry getZipEntry() {
        return this.fZipEntry;
    }

    public boolean equals(Object object) {
        if (object instanceof ZipEntryStorage) {
            ZipEntryStorage other = (ZipEntryStorage)((Object)object);
            if (this.fArchive.equals(other.fArchive) && this.getZipEntry().getName().equals(other.getZipEntry().getName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getZipEntry().getName().hashCode();
    }
}

