/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.cheatsheet;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSModel;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.BaseCSCreationOperation;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CSWizardMessages;

public class SimpleCSCreationOperation
extends BaseCSCreationOperation {
    public SimpleCSCreationOperation(IFile file) {
        super(file);
    }

    public SimpleCSCreationOperation(ISchedulingRule rule) {
        super(rule);
    }

    @Override
    protected void createContent() throws CoreException {
        SimpleCSModel model = new SimpleCSModel((IDocument)CoreUtility.getTextDocument((InputStream)this.fFile.getContents()), false);
        model.setUnderlyingResource((IResource)this.fFile);
        this.initializeCS(model.getSimpleCS());
        model.save();
        model.dispose();
    }

    protected void initializeCS(ISimpleCS simpleCS) {
        ISimpleCSModelFactory factory = simpleCS.getModel().getFactory();
        ISimpleCSIntro intro = factory.createSimpleCSIntro((ISimpleCSObject)simpleCS);
        ISimpleCSDescription description = factory.createSimpleCSDescription((ISimpleCSObject)intro);
        description.setContent(SimpleCSCreationOperation.formatTextBold(CSWizardMessages.SimpleCSCreationOperation_body));
        intro.setDescription(description);
        ISimpleCSItem item = factory.createSimpleCSItem((ISimpleCSObject)simpleCS);
        item.setTitle(CSWizardMessages.SimpleCSCreationOperation_item);
        ISimpleCSDescription description2 = factory.createSimpleCSDescription((ISimpleCSObject)item);
        description2.setContent(SimpleCSCreationOperation.formatTextBold(CSWizardMessages.SimpleCSCreationOperation_body));
        item.setDescription(description2);
        simpleCS.setTitle(CSWizardMessages.SimpleCSCreationOperation_title);
        simpleCS.setIntro(intro);
        simpleCS.addItem(item);
    }
}

