/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public class CreateLocalBranchOperation
implements IEGitOperation {
    private final String name;
    private final Repository repository;
    private final Ref ref;
    private final RevCommit commit;
    private final BranchConfig.BranchRebaseMode upstreamConfig;

    public CreateLocalBranchOperation(Repository repository, String name, Ref ref, BranchConfig.BranchRebaseMode config) {
        this.name = name;
        this.repository = repository;
        this.ref = ref;
        this.commit = null;
        this.upstreamConfig = config;
    }

    public CreateLocalBranchOperation(Repository repository, String name, RevCommit commit) {
        this.name = name;
        this.repository = repository;
        this.ref = null;
        this.commit = commit;
        this.upstreamConfig = null;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName = NLS.bind((String)CoreText.CreateLocalBranchOperation_CreatingBranchMessage, (Object)CreateLocalBranchOperation.this.name);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor);
                progress.setTaskName(taskName);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Git git = new Git(CreateLocalBranchOperation.this.repository);){
                        if (CreateLocalBranchOperation.this.ref != null) {
                            CreateBranchCommand.SetupUpstreamMode mode = CreateLocalBranchOperation.this.upstreamConfig == null ? CreateBranchCommand.SetupUpstreamMode.NOTRACK : CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM;
                            git.branchCreate().setName(CreateLocalBranchOperation.this.name).setStartPoint(CreateLocalBranchOperation.this.ref.getName()).setUpstreamMode(mode).call();
                        } else {
                            git.branchCreate().setName(CreateLocalBranchOperation.this.name).setStartPoint(CreateLocalBranchOperation.this.commit).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).call();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                if (CreateLocalBranchOperation.this.upstreamConfig != null) {
                    StoredConfig config = CreateLocalBranchOperation.this.repository.getConfig();
                    config.setEnum("branch", CreateLocalBranchOperation.this.name, "rebase", (Enum)CreateLocalBranchOperation.this.upstreamConfig);
                    try {
                        config.save();
                    }
                    catch (IOException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }

    public static BranchConfig.BranchRebaseMode getDefaultUpstreamConfig(Repository repo, String upstreamRefName) {
        boolean setupRebase;
        boolean setupMerge;
        boolean isLocalBranch = upstreamRefName.startsWith("refs/heads/");
        boolean isRemoteBranch = upstreamRefName.startsWith("refs/remotes/");
        if (!isLocalBranch && !isRemoteBranch) {
            return null;
        }
        String autosetupMerge = repo.getConfig().getString("branch", null, "autosetupmerge");
        if (autosetupMerge == null) {
            autosetupMerge = "true";
        }
        boolean bl = setupMerge = autosetupMerge.equals("always") || isRemoteBranch && autosetupMerge.equals("true");
        if (!setupMerge) {
            return null;
        }
        String autosetupRebase = repo.getConfig().getString("branch", null, "autosetuprebase");
        if (autosetupRebase == null) {
            autosetupRebase = "never";
        }
        boolean bl2 = setupRebase = autosetupRebase.equals("always") || autosetupRebase.equals("local") && isLocalBranch || autosetupRebase.equals("remote") && isRemoteBranch;
        if (setupRebase) {
            return BranchConfig.BranchRebaseMode.REBASE;
        }
        return BranchConfig.BranchRebaseMode.NONE;
    }
}

