/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.ui.memory.MemoryRenderingElement;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class AsyncTableRenderingCellModifier
implements ICellModifier {
    private AbstractAsyncTableRendering fRendering;
    private boolean fMBSupportsValueModification = false;
    private ICellModifier fCustomModifier;

    public AsyncTableRenderingCellModifier(AbstractAsyncTableRendering rendering, ICellModifier customModifier) {
        this.fRendering = rendering;
        this.fCustomModifier = customModifier;
        Job job = new Job("AsyncTableRenderingCellModifier"){

            protected IStatus run(IProgressMonitor monitor) {
                AsyncTableRenderingCellModifier.this.fMBSupportsValueModification = AsyncTableRenderingCellModifier.this.fRendering.getMemoryBlock().supportsValueModification();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canModify(Object element, String property) {
        MemorySegment line;
        boolean canModify;
        block10: {
            block9: {
                block8: {
                    canModify = true;
                    if (element instanceof MemorySegment) break block8;
                    return false;
                }
                if (this.isValueModificationSupported()) break block9;
                return false;
            }
            line = (MemorySegment)((Object)element);
            if (!"address".equals(property)) break block10;
            return false;
        }
        try {
            int addressableSize = this.getAddressableSize();
            int offset = Integer.parseInt(property, 16) * addressableSize;
            MemoryByte[] bytes = line.getBytes(offset, this.fRendering.getBytesPerColumn());
            if (this.fCustomModifier != null) {
                BigInteger address = line.getAddress().add(BigInteger.valueOf(offset));
                MemoryRenderingElement mElement = new MemoryRenderingElement(this.fRendering, address, bytes);
                return this.fCustomModifier.canModify((Object)mElement, null);
            }
            MemoryByte[] memoryByteArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                if (!b.isWritable()) {
                    canModify = false;
                }
                ++n2;
            }
            return canModify;
        }
        catch (NumberFormatException e) {
            canModify = false;
            return canModify;
        }
    }

    private int getAddressableSize() {
        int addressableSize = this.fRendering.getAddressableSize();
        if (addressableSize < 1) {
            addressableSize = 1;
        }
        return addressableSize;
    }

    public Object getValue(Object element, String property) {
        if (!(element instanceof MemorySegment)) {
            return null;
        }
        MemorySegment line = (MemorySegment)((Object)element);
        try {
            if ("address".equals(property)) {
                return line.getAddress();
            }
            int offsetToLineBuffer = Integer.parseInt(property, 16) * this.getAddressableSize();
            MemoryByte[] memory = line.getBytes(offsetToLineBuffer, this.fRendering.getBytesPerColumn());
            int offsetFromLineAddress = Integer.parseInt(property, 16);
            BigInteger address = line.getAddress().add(BigInteger.valueOf(offsetFromLineAddress));
            if (this.fCustomModifier != null) {
                MemoryRenderingElement mElement = new MemoryRenderingElement(this.fRendering, address, memory);
                return this.fCustomModifier.getValue((Object)mElement, null);
            }
            return this.fRendering.getString(this.fRendering.getRenderingId(), address, memory);
        }
        catch (NumberFormatException e) {
            return "00";
        }
    }

    public void modify(Object element, final String property, final Object value) {
        MemorySegment segment = null;
        if (element instanceof TableItem) {
            Object data = ((TableItem)element).getData();
            if (data != null && data instanceof MemorySegment) {
                segment = (MemorySegment)((Object)data);
            }
        } else if (element instanceof MemorySegment) {
            segment = (MemorySegment)((Object)element);
        }
        if (segment == null) {
            return;
        }
        final MemorySegment line = segment;
        Job job = new Job("Set Values"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IMemoryBlock memoryBlk = AsyncTableRenderingCellModifier.this.fRendering.getMemoryBlock();
                    int offsetFromLineAddress = Integer.parseInt(property, 16);
                    BigInteger offsetFromMBBase = AsyncTableRenderingCellModifier.this.getOffset(memoryBlk, line.getAddress(), offsetFromLineAddress);
                    int offsetToLineBuffer = Integer.parseInt(property, 16) * AsyncTableRenderingCellModifier.this.getAddressableSize();
                    MemoryByte[] oldArray = line.getBytes(offsetToLineBuffer, AsyncTableRenderingCellModifier.this.fRendering.getBytesPerColumn());
                    BigInteger address = line.getAddress();
                    address = address.add(BigInteger.valueOf(offsetFromLineAddress));
                    if (AsyncTableRenderingCellModifier.this.fCustomModifier != null) {
                        MemoryRenderingElement mElement = new MemoryRenderingElement(AsyncTableRenderingCellModifier.this.fRendering, address, oldArray);
                        AsyncTableRenderingCellModifier.this.fCustomModifier.modify((Object)mElement, null, value);
                        return Status.OK_STATUS;
                    }
                    if (!(value instanceof String)) {
                        DebugUIPlugin.logErrorMessage("Cell modifier cannot handle non-string values.");
                        return Status.OK_STATUS;
                    }
                    byte[] bytes = null;
                    String oldValue = (String)AsyncTableRenderingCellModifier.this.getValue((Object)line, property);
                    if (!oldValue.equals(value)) {
                        bytes = AsyncTableRenderingCellModifier.this.fRendering.getBytes(AsyncTableRenderingCellModifier.this.fRendering.getRenderingId(), address, oldArray, (String)value);
                        if (bytes == null) {
                            return Status.OK_STATUS;
                        }
                        if (bytes.length == 0) {
                            return Status.OK_STATUS;
                        }
                        if (bytes.length <= oldArray.length) {
                            boolean changed = false;
                            int i = 0;
                            while (i < bytes.length) {
                                if (bytes[i] != oldArray[i].getValue()) {
                                    changed = true;
                                    break;
                                }
                                ++i;
                            }
                            if (!changed) {
                                return Status.OK_STATUS;
                            }
                        }
                    } else {
                        return Status.OK_STATUS;
                    }
                    byte[] newByteValues = bytes;
                    if (memoryBlk instanceof IMemoryBlockExtension) {
                        ((IMemoryBlockExtension)memoryBlk).setValue(offsetFromMBBase, newByteValues);
                    } else {
                        memoryBlk.setValue(offsetFromMBBase.longValue(), newByteValues);
                    }
                }
                catch (DebugException e) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_failed, (Exception)((Object)e));
                }
                catch (NumberFormatException e) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_failed + "\n" + DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private BigInteger getOffset(IMemoryBlock memory, BigInteger lineAddress, int lineOffset) throws DebugException {
        BigInteger memoryAddr = memory instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memory).getBigBaseAddress() : BigInteger.valueOf(memory.getStartAddress());
        if (memoryAddr == null) {
            memoryAddr = BigInteger.ZERO;
        }
        return lineAddress.subtract(memoryAddr).add(BigInteger.valueOf(lineOffset));
    }

    private boolean isValueModificationSupported() {
        return this.fMBSupportsValueModification;
    }
}

