/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class MemoryBlockProxy
extends EventHandlerModelProxy {
    private final IMemoryBlock fMemoryBlock;
    private final DebugEventHandler fDebugEventHandler = new DebugEventHandler(this){

        @Override
        protected boolean handlesEvent(DebugEvent event) {
            if (event.getKind() == 16 && event.getSource() == MemoryBlockProxy.this.fMemoryBlock) {
                return true;
            }
            Object src = event.getSource();
            return src instanceof IDebugElement && event.getKind() == 2 && ((IDebugElement)src).getDebugTarget() == MemoryBlockProxy.this.fMemoryBlock.getDebugTarget();
        }

        @Override
        protected void handleChange(DebugEvent event) {
            if (event.getDetail() == 256) {
                ModelDelta delta = new ModelDelta(MemoryBlockProxy.this.fMemoryBlock, 2048);
                MemoryBlockProxy.this.fireModelChanged(delta);
            } else {
                ModelDelta delta = new ModelDelta(MemoryBlockProxy.this.fMemoryBlock, 1024);
                MemoryBlockProxy.this.fireModelChanged(delta);
            }
        }

        @Override
        protected void handleSuspend(DebugEvent event) {
            ModelDelta delta = new ModelDelta(MemoryBlockProxy.this.fMemoryBlock, 1024);
            MemoryBlockProxy.this.fireModelChanged(delta);
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
        }
    };

    public MemoryBlockProxy(IMemoryBlock mb) {
        this.fMemoryBlock = mb;
    }

    @Override
    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{this.fDebugEventHandler};
    }

    @Override
    public void installed(Viewer viewer) {
        super.installed(viewer);
        this.setInstalled(true);
    }
}

