/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.MemoryRenderingType;
import org.eclipse.debug.internal.ui.memory.RenderingBindings;
import org.eclipse.debug.ui.memory.AbstractMemoryRenderingBindingsProvider;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;

public class MemoryRenderingManager
extends AbstractMemoryRenderingBindingsProvider
implements IMemoryRenderingManager {
    private final Map<String, MemoryRenderingType> fRenderingTypes = new HashMap<String, MemoryRenderingType>();
    private final List<RenderingBindings> fBindings = new ArrayList<RenderingBindings>();
    private static MemoryRenderingManager fgDefault;
    public static final String ELEMENT_MEMORY_RENDERING_TYPE = "renderingType";
    public static final String ELEMENT_RENDERING_BINDINGS = "renderingBindings";

    public static IMemoryRenderingManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new MemoryRenderingManager();
        }
        return fgDefault;
    }

    private MemoryRenderingManager() {
        this.initializeRenderings();
    }

    public IMemoryRendering createRendering(String id) throws CoreException {
        IMemoryRenderingType type = this.getRenderingType(id);
        if (type != null) {
            return type.createRendering();
        }
        return null;
    }

    @Override
    public IMemoryRenderingType[] getRenderingTypes() {
        Collection<MemoryRenderingType> types = this.fRenderingTypes.values();
        return types.toArray(new IMemoryRenderingType[types.size()]);
    }

    @Override
    public IMemoryRenderingType getRenderingType(String id) {
        return this.fRenderingTypes.get(id);
    }

    @Override
    public IMemoryRenderingType[] getDefaultRenderingTypes(IMemoryBlock block) {
        ArrayList<IMemoryRenderingType> allTypes = new ArrayList<IMemoryRenderingType>();
        for (RenderingBindings binding : this.fBindings) {
            IMemoryRenderingType[] renderingTypes;
            IMemoryRenderingType[] iMemoryRenderingTypeArray = renderingTypes = binding.getDefaultRenderingTypes(block);
            int n = renderingTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
                if (!allTypes.contains(type)) {
                    allTypes.add(type);
                }
                ++n2;
            }
        }
        return allTypes.toArray(new IMemoryRenderingType[allTypes.size()]);
    }

    @Override
    public IMemoryRenderingType getPrimaryRenderingType(IMemoryBlock block) {
        for (RenderingBindings binding : this.fBindings) {
            IMemoryRenderingType renderingType = binding.getPrimaryRenderingType(block);
            if (renderingType == null) continue;
            return renderingType;
        }
        return null;
    }

    @Override
    public IMemoryRenderingType[] getRenderingTypes(IMemoryBlock block) {
        ArrayList<IMemoryRenderingType> allTypes = new ArrayList<IMemoryRenderingType>();
        for (RenderingBindings binding : this.fBindings) {
            IMemoryRenderingType[] renderingTypes;
            IMemoryRenderingType[] iMemoryRenderingTypeArray = renderingTypes = binding.getRenderingTypes(block);
            int n = renderingTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
                if (!allTypes.contains(type)) {
                    allTypes.add(type);
                }
                ++n2;
            }
        }
        return allTypes.toArray(new IMemoryRenderingType[allTypes.size()]);
    }

    private void initializeRenderings() {
        IConfigurationElement[] configurationElements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "memoryRenderings");
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals(ELEMENT_MEMORY_RENDERING_TYPE)) {
                MemoryRenderingType type = new MemoryRenderingType(element);
                try {
                    type.validate();
                    this.fRenderingTypes.put(type.getId(), type);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            } else if (name.equals(ELEMENT_RENDERING_BINDINGS)) {
                RenderingBindings bindings = new RenderingBindings(element);
                try {
                    bindings.validate();
                    this.fBindings.add(bindings);
                    bindings.addListener(this::fireBindingsChanged);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            ++n2;
        }
    }
}

