/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.internal.ui.contexts.DebugWindowContextService;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class DebugContextManager
implements IDebugContextManager {
    private static DebugContextManager fgDefault;
    private final Map<IWorkbenchWindow, DebugWindowContextService> fServices = new HashMap<IWorkbenchWindow, DebugWindowContextService>();
    private final ListenerList<IDebugContextListener> fGlobalListeners = new ListenerList();
    private static IDebugContextService NULL_SERVICE;

    static {
        NULL_SERVICE = new IDebugContextService(){

            @Override
            public void removePostDebugContextListener(IDebugContextListener listener, String partId) {
            }

            @Override
            public void removePostDebugContextListener(IDebugContextListener listener) {
            }

            @Override
            public void removeDebugContextProvider(IDebugContextProvider provider) {
            }

            @Override
            public void removeDebugContextListener(IDebugContextListener listener, String partId) {
            }

            @Override
            public void removeDebugContextListener(IDebugContextListener listener) {
            }

            @Override
            public ISelection getActiveContext(String partId) {
                return null;
            }

            @Override
            public ISelection getActiveContext() {
                return null;
            }

            @Override
            public void addPostDebugContextListener(IDebugContextListener listener, String partId) {
            }

            @Override
            public void addPostDebugContextListener(IDebugContextListener listener) {
            }

            @Override
            public void addDebugContextProvider(IDebugContextProvider provider) {
            }

            @Override
            public void addDebugContextListener(IDebugContextListener listener, String partId) {
            }

            @Override
            public void addDebugContextListener(IDebugContextListener listener) {
            }

            @Override
            public void addDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            @Override
            public void removeDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            @Override
            public ISelection getActiveContext(String partId, String partSecondaryId) {
                return null;
            }

            @Override
            public void addPostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            @Override
            public void removePostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }
        };
    }

    private DebugContextManager() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    public static IDebugContextManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new DebugContextManager();
            DebugModelContextBindingManager.getDefault();
            ViewContextManager.getDefault();
        }
        return fgDefault;
    }

    protected IDebugContextService createService(IWorkbenchWindow window) {
        DebugWindowContextService service = this.fServices.get(window);
        if (service == null) {
            if (window == null) {
                return NULL_SERVICE;
            }
            IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
            if (window.getShell() == null || evaluationService == null) {
                return NULL_SERVICE;
            }
            service = new DebugWindowContextService(window, evaluationService);
            this.fServices.put(window, service);
            for (IDebugContextListener iDebugContextListener : this.fGlobalListeners) {
                service.addDebugContextListener(iDebugContextListener);
            }
        }
        return service;
    }

    protected IDebugContextService getService(IWorkbenchWindow window) {
        return this.fServices.get(window);
    }

    @Override
    public void addDebugContextListener(IDebugContextListener listener) {
        DebugWindowContextService[] services;
        this.fGlobalListeners.add((Object)listener);
        DebugWindowContextService[] debugWindowContextServiceArray = services = this.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            DebugWindowContextService service = debugWindowContextServiceArray[n2];
            service.addDebugContextListener(listener);
            ++n2;
        }
    }

    @Override
    public void removeDebugContextListener(IDebugContextListener listener) {
        DebugWindowContextService[] services;
        this.fGlobalListeners.remove((Object)listener);
        DebugWindowContextService[] debugWindowContextServiceArray = services = this.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            DebugWindowContextService service = debugWindowContextServiceArray[n2];
            service.removeDebugContextListener(listener);
            ++n2;
        }
    }

    private DebugWindowContextService[] getServices() {
        Collection<DebugWindowContextService> sevices = this.fServices.values();
        return sevices.toArray(new DebugWindowContextService[sevices.size()]);
    }

    @Override
    public IDebugContextService getContextService(IWorkbenchWindow window) {
        return this.createService(window);
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            DebugWindowContextService service = DebugContextManager.this.fServices.get(window);
            if (service != null) {
                DebugContextManager.this.fServices.remove(window);
                service.dispose();
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

