/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.IdentifiableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.w3c.dom.Node;

public class FeatureChild
extends IdentifiableObject
implements IFeatureChild {
    private static final long serialVersionUID = 1L;
    private String fVersion;
    private String fName;
    private boolean fOptional;
    private int fSearchLocation = 0;
    private String fOs;
    private String fWs;
    private String fArch;
    private String fNl;
    private String fFilter;

    @Override
    protected void reset() {
        super.reset();
        this.fVersion = null;
        this.fOptional = false;
        this.fName = null;
        this.fSearchLocation = 0;
        this.fOs = null;
        this.fWs = null;
        this.fArch = null;
        this.fNl = null;
        this.fFilter = null;
    }

    @Override
    protected void parse(Node node) {
        block14: {
            super.parse(node);
            this.fVersion = this.getNodeAttribute(node, "version");
            this.fName = this.getNodeAttribute(node, "name");
            this.fOptional = this.getBooleanAttribute(node, "optional");
            this.fOs = this.getNodeAttribute(node, "os");
            this.fWs = this.getNodeAttribute(node, "ws");
            this.fArch = this.getNodeAttribute(node, "arch");
            this.fNl = this.getNodeAttribute(node, "nl");
            this.fFilter = this.getNodeAttribute(node, "filter");
            String searchLocationName = this.getNodeAttribute(node, "search_location");
            if (searchLocationName == null) {
                searchLocationName = this.getNodeAttribute(node, "search-location");
            }
            if (searchLocationName == null) break block14;
            switch (searchLocationName) {
                case "root": {
                    this.fSearchLocation = 0;
                    break;
                }
                case "self": {
                    this.fSearchLocation = 1;
                    break;
                }
                case "both": {
                    this.fSearchLocation = 2;
                    break;
                }
            }
        }
    }

    public void loadFrom(IFeature feature) {
        this.id = feature.getId();
        this.fVersion = feature.getVersion();
        this.fOptional = false;
        this.fName = null;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public boolean isOptional() {
        return this.fOptional;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getSearchLocation() {
        return this.fSearchLocation;
    }

    @Override
    public String getOS() {
        return this.fOs;
    }

    @Override
    public String getWS() {
        return this.fWs;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public String getNL() {
        return this.fNl;
    }

    @Override
    public String getFilter() {
        return this.fFilter;
    }

    public IFeature getReferencedFeature() {
        IFeatureModel workspaceModel = PDECore.getDefault().getFeatureModelManager().findFeatureModel(this.getId(), this.fVersion);
        if (workspaceModel != null) {
            return workspaceModel.getFeature();
        }
        return null;
    }

    @Override
    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fVersion;
        this.fVersion = version;
        this.firePropertyChanged("version", oldValue, version);
    }

    @Override
    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fName;
        this.fName = name;
        this.firePropertyChanged("name", oldValue, name);
    }

    @Override
    public void setSearchLocation(int searchLocation) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = this.fSearchLocation;
        this.fSearchLocation = searchLocation;
        this.firePropertyChanged("search-location", oldValue, searchLocation);
    }

    @Override
    public void setOptional(boolean optional) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = this.fOptional;
        this.fOptional = optional;
        this.firePropertyChanged("name", oldValue, optional);
    }

    @Override
    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fOs;
        this.fOs = os;
        this.firePropertyChanged("os", oldValue, os);
    }

    @Override
    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fWs;
        this.fWs = ws;
        this.firePropertyChanged("ws", oldValue, ws);
    }

    @Override
    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fArch;
        this.fArch = arch;
        this.firePropertyChanged("arch", oldValue, arch);
    }

    @Override
    public void setNL(String nl) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fNl;
        this.fNl = nl;
        this.firePropertyChanged("nl", oldValue, nl);
    }

    @Override
    public void setFilter(String filter) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fFilter;
        this.fFilter = filter;
        this.firePropertyChanged("filter", oldValue, filter);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        switch (name) {
            case "version": {
                this.setVersion((String)newValue);
                break;
            }
            case "optional": {
                this.setOptional((Boolean)newValue);
                break;
            }
            case "name": {
                this.setName((String)newValue);
                break;
            }
            case "os": {
                this.setOS((String)newValue);
                break;
            }
            case "ws": {
                this.setWS((String)newValue);
                break;
            }
            case "arch": {
                this.setArch((String)newValue);
                break;
            }
            case "nl": {
                this.setNL((String)newValue);
                break;
            }
            case "search-location": {
                this.setSearchLocation(newValue != null ? (Integer)newValue : 0);
                break;
            }
            default: {
                super.restoreProperty(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void setId(String id) throws CoreException {
        super.setId(id);
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent + "<includes");
        String indent2 = indent + "      ";
        if (this.getId() != null) {
            writer.println();
            writer.print(indent2 + "id=\"" + this.getId() + "\"");
        }
        if (this.getVersion() != null) {
            writer.println();
            writer.print(indent2 + "version=\"" + this.getVersion() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print(indent2 + "name=\"" + this.getName() + "\"");
        }
        if (this.isOptional()) {
            writer.println();
            writer.print(indent2 + "optional=\"true\"");
        }
        if (this.getOS() != null) {
            writer.println();
            writer.print(indent2 + "os=\"" + this.getOS() + "\"");
        }
        if (this.getWS() != null) {
            writer.println();
            writer.print(indent2 + "ws=\"" + this.getWS() + "\"");
        }
        if (this.getArch() != null) {
            writer.println();
            writer.print(indent2 + "arch=\"" + this.getArch() + "\"");
        }
        if (this.getNL() != null) {
            writer.println();
            writer.print(indent2 + "nl=\"" + this.getNL() + "\"");
        }
        if (this.fSearchLocation != 0) {
            writer.println();
            String value = this.fSearchLocation == 1 ? "self" : "both";
            writer.print(indent2 + "search-location=\"" + value + "\"");
        }
        if (this.getFilter() != null) {
            writer.println();
            writer.print(indent2 + "filter=\"" + this.getFilter() + "\"");
        }
        writer.println("/>");
    }
}

