/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class ExternalBuildModel
extends BuildModel {
    private static final long serialVersionUID = 1L;
    private final String fInstallLocation;

    public ExternalBuildModel(String installLocation) {
        this.fInstallLocation = installLocation;
    }

    @Override
    public String getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void load() {
        try {
            URL url = null;
            File file = new File(this.getInstallLocation());
            url = file.isFile() ? new URL("jar:file:" + file.getAbsolutePath() + "!/build.properties") : new URL("file:" + file.getAbsolutePath() + "/build.properties");
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = url.openStream();){
                this.load(stream, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.fBuild = new Build();
            this.fBuild.setModel(this);
            this.setLoaded(true);
        }
    }

    @Override
    protected void updateTimeStamp() {
        this.updateTimeStamp(this.getLocalFile());
    }

    private File getLocalFile() {
        File file = new File(this.getInstallLocation());
        return file.isFile() ? file : new File(file, "build.properties");
    }

    @Override
    public boolean isInSync() {
        return true;
    }
}

