/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.reporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaException;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaStackTraceEntry;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;

public class SimpleReportGenerator {
    private static final String LINE_SEPARATOR = "\n";

    public String generateContent(Report report) {
        StringBuilder builder = new StringBuilder();
        Node nodes = report.getRoot();
        builder.append("Report:").append(LINE_SEPARATOR);
        this.printNode(nodes, builder, 1, false);
        builder.append("Q7 Wait details");
        this.printNode(nodes, builder, 1, true);
        return builder.toString();
    }

    protected boolean printRawProperty(String key) {
        return true;
    }

    public void printNode(Node infoNode, StringBuilder stream, int tabs, boolean includeWaitDetails) {
        this.appendTabs(stream, tabs);
        stream.append(infoNode.getName()).append(" ").append(Long.toString(infoNode.getDuration()));
        stream.append(" {").append(LINE_SEPARATOR);
        EMap<String, EObject> list = infoNode.getProperties();
        for (String key : list.keySet()) {
            if (!this.printRawProperty(key)) continue;
            EObject value = (EObject)list.get((Object)key);
            if (value instanceof Q7WaitInfoRoot) {
                if (!includeWaitDetails) continue;
                this.printWaitInfo(stream, tabs, key, (Q7WaitInfoRoot)value);
                continue;
            }
            if (includeWaitDetails) continue;
            this.appendTabs(stream, tabs + 1).append(key).append("=").append(this.asValue(value)).append(LINE_SEPARATOR);
        }
        this.printChildren((List<Node>)infoNode.getChildren(), stream, tabs, includeWaitDetails);
        try {
            if (!includeWaitDetails) {
                for (Snaphot child : infoNode.getSnapshots()) {
                    this.printSnapshot(child, stream, tabs + 2);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.appendTabs(stream, tabs).append("}").append(LINE_SEPARATOR);
    }

    protected void printChildren(List<Node> children, StringBuilder stream, int tabs, boolean includeWaitDetails) {
        for (Node child : children) {
            this.printNode(child, stream, tabs + 2, includeWaitDetails);
        }
    }

    public void printWaitInfo(StringBuilder stream, int tabs, String key, Q7WaitInfoRoot info) {
        ArrayList infos = new ArrayList(info.getInfos());
        if (infos.size() == 0) {
            return;
        }
        Comparator<Q7WaitInfo> comparator = new Comparator<Q7WaitInfo>(){

            @Override
            public int compare(Q7WaitInfo info1, Q7WaitInfo info2) {
                return Long.compare(info1.getDuration(), info2.getDuration());
            }
        };
        Collections.sort(infos, Collections.reverseOrder(comparator));
        boolean isEmpty = true;
        for (Q7WaitInfo q7WaitInfo : infos) {
            if (SimpleReportGenerator.getType(info, q7WaitInfo) == null || !TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && SimpleReportGenerator.getClassName(info, q7WaitInfo).startsWith("org.eclipse") || q7WaitInfo.getDuration() == 0L) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return;
        }
        this.appendTabs(stream, tabs + 4).append("--> Wait details <--").append(LINE_SEPARATOR);
        for (Q7WaitInfo i : infos) {
            long totalTime = i.getDuration();
            String type = SimpleReportGenerator.getType(info, i);
            String className = SimpleReportGenerator.getClassName(info, i);
            if (type == null || !TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && className.startsWith("org.eclipse") || totalTime == 0L) continue;
            this.appendTabs(stream, tabs + 8).append(type).append(": ").append(className);
            if (totalTime != 0L) {
                stream.append(", total time: ").append(Long.toString(totalTime));
            }
            stream.append(LINE_SEPARATOR);
        }
    }

    public static String getType(Q7WaitInfo q7WaitInfo) {
        Q7WaitInfoRoot info = (Q7WaitInfoRoot)q7WaitInfo.eContainer();
        if (info == null) {
            throw new NullPointerException("Unrooted object");
        }
        return SimpleReportGenerator.getType(info, q7WaitInfo);
    }

    public static String getType(Q7WaitInfoRoot info, Q7WaitInfo q7WaitInfo) {
        String type = (String)info.getTypesNames().get(q7WaitInfo.getTypeId());
        if (!TeslaFeatures.isIncludeIgnoredWaitDetails() && type.contains("(ignored)")) {
            return null;
        }
        return type;
    }

    private String asValue(EObject eObject) {
        StringBuilder b = new StringBuilder();
        try {
            this.toString(b, 0, eObject, new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "(" + b.toString().replace(LINE_SEPARATOR, " ") + ")";
    }

    public <T extends Appendable> T printSnapshot(Snaphot child, T stream, int tabs) throws IOException {
        this.appendTabs(stream, tabs);
        stream.append(" %");
        stream.append(" object:").append(LINE_SEPARATOR);
        this.toString(stream, tabs + 1, child.getData(), new String[0]).append(LINE_SEPARATOR);
        EMap<String, EObject> list = child.getProperties();
        for (String key : list.keySet()) {
            this.appendTabs(stream, tabs + 1).append(key).append("=").append(this.asValue((EObject)list.get((Object)key))).append(LINE_SEPARATOR);
        }
        this.appendTabs(stream, tabs).append("%").append(LINE_SEPARATOR);
        return stream;
    }

    protected <T extends Appendable> T appendTabs(T stream, int tabs) {
        int i = 0;
        while (i < tabs) {
            try {
                stream.append("  ");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return stream;
    }

    public <T extends Appendable> T printStatus(EclipseStatus s, int tabs, T builder) throws IOException {
        int severity = s.getSeverity();
        if (severity == 4) {
            this.appendTabs(builder, tabs).append("Error");
        }
        if (severity == 1) {
            this.appendTabs(builder, tabs).append("Info");
        }
        if (severity == 2) {
            this.appendTabs(builder, tabs).append("Warning");
        }
        builder.append(" in plugin: ").append(s.getPlugin()).append(LINE_SEPARATOR);
        this.appendTabs(builder, tabs).append("message: ").append(s.getMessage()).append(LINE_SEPARATOR);
        if (s.getException() != null) {
            this.appendTabs(builder, tabs).append("exception: ").append(LINE_SEPARATOR);
            this.printJavaException(s.getException(), tabs + 2, builder);
        }
        return builder;
    }

    private Appendable printJavaException(JavaException e, int tabs, Appendable builder) throws IOException {
        this.appendTabs(builder, tabs).append(e.getClassName());
        if (e.getMessage() != null && e.getMessage().length() > 0) {
            builder.append(":").append(e.getMessage());
        }
        builder.append(LINE_SEPARATOR);
        for (JavaStackTraceEntry st : e.getStackTrace()) {
            this.appendTabs(builder, tabs + 2).append("at ").append(st.getClassName()).append(".").append(st.getMethodName()).append("(").append(st.getFileName()).append(":").append("" + st.getLineNumber()).append(")").append(LINE_SEPARATOR);
        }
        JavaException cause = e.getCause();
        if (cause != null) {
            this.appendTabs(builder, tabs + 2).append("Caused by:").append(LINE_SEPARATOR);
            this.printJavaException(cause, tabs + 4, builder);
        }
        return builder;
    }

    public <T extends Appendable> T toString(T builder, int tabs, EObject obj, String ... ignores) throws IOException {
        return this.toString(builder, tabs, obj, true, ignores);
    }

    public <T extends Appendable> T toString(T builder, int tabs, EObject obj, boolean skipDefaults, String ... ignores) throws IOException {
        if (obj instanceof EclipseStatus) {
            try {
                return this.printStatus((EclipseStatus)obj, tabs, builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (obj == null) {
            return builder;
        }
        EClass eClass = obj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            Object eGet = obj.eGet(f);
            boolean needArg = true;
            Object defaultValue = f.getDefaultValue();
            boolean bl = needArg = defaultValue == null || !defaultValue.equals(eGet);
            if (eGet instanceof List && ((List)eGet).size() == 0) {
                needArg = false;
            }
            if (!skipDefaults) {
                needArg = true;
            }
            String[] stringArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                String ignore = stringArray[n2];
                if (ignore.equals(f.getName())) {
                    needArg = false;
                    break;
                }
                ++n2;
            }
            if (eGet == null || !needArg) continue;
            this.appendTabs(builder, tabs).append(f.getName()).append('=');
            if (eGet instanceof EObject) {
                builder.append('{').append(LINE_SEPARATOR);
                this.toString(builder, tabs + 1, (EObject)eGet, "eFactoryInstance").append('}');
                continue;
            }
            if (eGet instanceof EList) {
                EList l = (EList)eGet;
                builder.append('[');
                int i = 0;
                while (i < l.size()) {
                    Object va = l.get(i);
                    if (va instanceof EObject) {
                        if (i != 0) {
                            this.appendTabs(builder, tabs + 2);
                        }
                        builder.append('{').append(LINE_SEPARATOR);
                        this.toString(builder, tabs + 4, (EObject)va, "eFactoryInstance");
                        this.appendTabs(builder, tabs + 2).append('}').append(LINE_SEPARATOR);
                    }
                    ++i;
                }
                builder.append(']');
                continue;
            }
            builder.append("" + eGet).append(LINE_SEPARATOR);
        }
        return builder;
    }

    public static String getClassName(Q7WaitInfoRoot waitRoot, Q7WaitInfo i) {
        String className = (String)waitRoot.getClassNames().get(i.getClassId());
        if (className != null && waitRoot.getInnerClassMap().containsKey((Object)className)) {
            String originalClassName = className;
            int pos = className.indexOf("$");
            if (pos != -1) {
                className = className.substring(0, pos);
            }
            className = String.valueOf(className) + '.' + (String)waitRoot.getInnerClassMap().get((Object)originalClassName);
        }
        return className;
    }
}

