/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public final class TextField
extends Field {
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED = new FieldType();
    private final StoredValue storedValue;

    public TextField(String name, Reader reader) {
        super(name, reader, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    public TextField(String name, String value, Field.Store store) {
        super(name, value, (IndexableFieldType)(store == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.storedValue = store == Field.Store.YES ? new StoredValue(value) : null;
    }

    public TextField(String name, TokenStream stream) {
        super(name, stream, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(value);
        if (this.storedValue != null) {
            this.storedValue.setStringValue(value);
        }
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    static {
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_NOT_STORED.setTokenized(true);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_STORED.setTokenized(true);
        TYPE_STORED.setStored(true);
        TYPE_STORED.freeze();
    }
}

