/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class EMFResourceContentProperty
extends SimpleListProperty {
    protected List<?> doGetList(Object source) {
        Resource resource = (Resource)source;
        return resource.getContents();
    }

    protected void doSetList(Object source, List list, ListDiff diff) {
        List<?> currentList = this.doGetList(source);
        diff.applyTo(currentList);
    }

    public Object getElementType() {
        return null;
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new Listener(listener);
    }

    private class Listener
    extends AdapterImpl
    implements INativePropertyListener {
        private ISimplePropertyListener listener;

        private Listener(ISimplePropertyListener listener) {
            this.listener = listener;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(Resource.class) == 2 && !msg.isTouch()) {
                ListDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)msg.getNewValue()));
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[newValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object newValue : newValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)true, newValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 4: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)false, (Object)msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[oldValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object oldValue : oldValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)false, oldValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 7: {
                        Object movedValue = msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)((Integer)msg.getOldValue()), (boolean)false, (Object)movedValue), Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)movedValue)};
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), (IProperty)EMFResourceContentProperty.this, (IDiff)diff));
            }
        }

        public void addTo(Object source) {
            if (source == null) {
                return;
            }
            Resource resource = (Resource)source;
            NotifyingList wrappedList = (NotifyingList)resource.getContents();
            if (!(wrappedList.getNotifier() instanceof Notifier)) {
                throw new IllegalArgumentException("Wrapped list must have a notifier attached!");
            }
            Notifier notifier = (Notifier)wrappedList.getNotifier();
            notifier.eAdapters().add((Object)this);
        }

        public void removeFrom(Object source) {
            if (source == null) {
                return;
            }
            Resource resource = (Resource)source;
            NotifyingList wrappedList = (NotifyingList)resource.getContents();
            if (!(wrappedList.getNotifier() instanceof Notifier)) {
                throw new IllegalArgumentException("Wrapped list must have a notifier attached!");
            }
            Notifier notifier = (Notifier)wrappedList.getNotifier();
            notifier.eAdapters().remove((Object)this);
        }
    }
}

