/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.ecl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Exec;
import org.eclipse.rcptt.ecl.core.ExecutableParameter;
import org.eclipse.rcptt.ecl.core.LiteralParameter;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.tesla.ecl.TeslaScriptletFactory;
import org.eclipse.rcptt.tesla.ecl.model.GetItem;
import org.eclipse.rcptt.tesla.ecl.model.Select;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.TeslaPackage;
import org.eclipse.rcptt.util.TableTreeItemPathUtil;

public class TeslaParserUtil {
    private static final Pattern IndexedSegmentPattern = Pattern.compile("(.*)%(\\d+)%");

    public static Command cut(Command target, Command start) {
        if (target instanceof Pipeline) {
            return TeslaParserUtil.cut((Pipeline)target, start);
        }
        return null;
    }

    public static Command cut(Pipeline target, Command start) {
        if (start instanceof Pipeline) {
            return TeslaParserUtil.cut(target, (Pipeline)start);
        }
        if (target.getCommands().size() <= 1) {
            return null;
        }
        Command first = (Command)target.getCommands().get(0);
        if (EcoreUtil.equals((EObject)first, (EObject)start)) {
            target = target != null ? (Pipeline)EcoreUtil.copy((EObject)target) : null;
            target.getCommands().remove(0);
            if (target.getCommands().size() == 1) {
                return (Command)target.getCommands().get(0);
            }
            return target;
        }
        return null;
    }

    public static Command cut(Pipeline target, Pipeline start) {
        int size;
        int targetSize = target.getCommands().size();
        if (targetSize < (size = start.getCommands().size())) {
            return null;
        }
        int i = 0;
        while (i < size) {
            if (!EcoreUtil.equals((EObject)((EObject)target.getCommands().get(i)), (EObject)((EObject)start.getCommands().get(i)))) {
                return null;
            }
            ++i;
        }
        target = target != null ? (Pipeline)EcoreUtil.copy((EObject)target) : null;
        ArrayList subList = new ArrayList(target.getCommands().subList(size, targetSize));
        target.getCommands().clear();
        target.getCommands().addAll(subList);
        if (target.getCommands().size() == 1) {
            return (Command)target.getCommands().get(0);
        }
        return target;
    }

    public static Command makeSelect(List<Command> items) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean sameColumn = true;
        boolean firstVal = true;
        String columnName = null;
        for (Command i : items) {
            if (i instanceof GetItem) {
                GetItem item = (GetItem)i;
                if (item.getIndex() != null) {
                    sameColumn = false;
                    break;
                }
                if (item.getColumn() == null || !item.getColumn().equals(columnName)) {
                    if (!firstVal) {
                        sameColumn = false;
                        break;
                    }
                    columnName = item.getColumn();
                }
            }
            firstVal = false;
        }
        for (Command i : items) {
            if (i instanceof GetItem && ((GetItem)i).getIndex() == null && (((GetItem)i).getColumn() == null || sameColumn)) {
                LiteralParameter literal = CoreFactory.eINSTANCE.createLiteralParameter();
                literal.setName(TeslaPackage.Literals.SELECT__ITEMS.getName());
                literal.setLiteral(((GetItem)i).getPath());
                parameters.add(literal);
                continue;
            }
            ExecutableParameter executable = CoreFactory.eINSTANCE.createExecutableParameter();
            executable.setCommand(i);
            executable.setName(TeslaPackage.Literals.SELECT__ITEMS.getName());
            parameters.add(executable);
        }
        if (sameColumn && columnName != null) {
            LiteralParameter columnLiteral = CoreFactory.eINSTANCE.createLiteralParameter();
            columnLiteral.setName(TeslaPackage.Literals.SELECT__COLUMN.getName());
            columnLiteral.setLiteral(columnName);
            parameters.add(columnLiteral);
        }
        Exec exec = CoreFactory.eINSTANCE.createExec();
        exec.setName(EclCommandNameConvention.toCommandName((String)TeslaPackage.Literals.SELECT.getName()));
        exec.getParameters().addAll(parameters);
        return exec;
    }

    public static Command makeSelect(String text) {
        Select cmd = TeslaFactory.eINSTANCE.createSelect();
        cmd.getItems().add((Object)text);
        return cmd;
    }

    public static Command makeItem(List<String> path) {
        if (path.size() == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        ArrayList<GetItem> items = new ArrayList<GetItem>();
        StringBuilder item = new StringBuilder();
        String columnName = null;
        boolean empty = true;
        boolean firstSegment = true;
        for (String segment : path) {
            columnName = TableTreeItemPathUtil.findColumnName((String)segment);
            String trimSegment = TableTreeItemPathUtil.excludeColumnName((String)segment);
            Matcher matcher = IndexedSegmentPattern.matcher(trimSegment);
            if (matcher.matches()) {
                if (!empty) {
                    items.add(TeslaScriptletFactory.makeItem((String)item.toString(), null, (String)columnName));
                    item.setLength(0);
                    empty = true;
                }
                String p = matcher.group(1);
                p = p.replace("/", "\\/");
                int i = Integer.parseInt(matcher.group(2));
                items.add(TeslaScriptletFactory.makeItem((String)p, (Integer)i, (String)columnName));
                firstSegment = true;
                continue;
            }
            if (!firstSegment) {
                item.append('/');
            }
            trimSegment = trimSegment.replace("/", "\\/");
            item.append(trimSegment);
            empty = false;
            firstSegment = false;
        }
        if (!empty) {
            items.add(TeslaScriptletFactory.makeItem((String)item.toString(), null, (String)columnName));
        }
        if (items.size() == 1) {
            return (Command)items.get(0);
        }
        return TeslaScriptletFactory.makePipe(items);
    }

    public static Command makeMenu(List<String> path, Integer index) {
        if (path.size() == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        ArrayList<Object> items = new ArrayList<Object>();
        StringBuilder item = new StringBuilder();
        for (String segment : path) {
            Matcher matcher = IndexedSegmentPattern.matcher(segment);
            if (matcher.matches()) {
                if (item.length() > 0) {
                    items.add(TeslaScriptletFactory.makeItem((String)item.toString(), null));
                    item.setLength(0);
                }
                String p = matcher.group(1);
                int i = Integer.parseInt(matcher.group(2));
                items.add(TeslaScriptletFactory.makeMenu((String)p, (Integer)i));
                continue;
            }
            if (item.length() > 0) {
                item.append('/');
            }
            segment = segment.replace("/", "\\/");
            item.append(segment);
        }
        if (item.length() > 0) {
            items.add(TeslaScriptletFactory.makeMenu((String)item.toString(), (Integer)index));
        }
        if (items.size() == 1) {
            return (Command)items.get(0);
        }
        return TeslaScriptletFactory.makePipe(items);
    }
}

