/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclDouble;
import org.eclipse.rcptt.ecl.core.EclFloat;
import org.eclipse.rcptt.ecl.core.EclInteger;
import org.eclipse.rcptt.ecl.core.EclLong;
import org.eclipse.rcptt.ecl.operations.Between;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.operations.internal.commands.BinaryOpService;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class BetweenService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Between)) {
            return Status.CANCEL_STATUS;
        }
        Between bw = (Between)command;
        BoxedValue input = BinaryOpService.convertToNumber(bw.getInput());
        BoxedValue from = BinaryOpService.convertToNumber(bw.getLeft());
        BoxedValue to = BinaryOpService.convertToNumber(bw.getRight());
        EClass widestType = BinaryOpService.max(input.eClass(), from.eClass(), to.eClass());
        input = BoxedValues.toType((BoxedValue)input, (EClass)widestType);
        from = BoxedValues.toType((BoxedValue)from, (EClass)widestType);
        to = BoxedValues.toType((BoxedValue)to, (EClass)widestType);
        context.getOutput().write((Object)BetweenService.isBetween(input, from, to));
        return Status.OK_STATUS;
    }

    private static boolean isBetween(BoxedValue input, BoxedValue from, BoxedValue to) throws CoreException {
        if (input instanceof EclInteger) {
            int i = ((EclInteger)input).getValue();
            int f = ((EclInteger)from).getValue();
            int t = ((EclInteger)to).getValue();
            return i <= t && i >= f;
        }
        if (input instanceof EclLong) {
            long i = ((EclLong)input).getValue();
            long f = ((EclLong)from).getValue();
            long t = ((EclLong)to).getValue();
            return i <= t && i >= f;
        }
        if (input instanceof EclFloat) {
            float i = ((EclFloat)input).getValue();
            float f = ((EclFloat)from).getValue();
            float t = ((EclFloat)to).getValue();
            return i <= t && i >= f;
        }
        if (input instanceof EclDouble) {
            double i = ((EclDouble)input).getValue();
            double f = ((EclLong)from).getValue();
            double t = ((EclLong)to).getValue();
            return i <= t && i >= f;
        }
        throw new CoreException(OperationsPlugin.createErr("Unexpected argument type: %s", input.eClass().getName()));
    }
}

