/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterPanelPart {
    private static final String PROP_FILTER = "filter";
    private static final long SEARCH_DELAY = 300L;
    private final ScheduledExecutorService scheduler;
    private String filter;
    private Composite panel;
    private Text txtFilter;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final Lock scheduledFilterLock = new ReentrantLock();
    private final Runnable updateFilterTask = () -> {
        Display display = this.panel.getDisplay();
        Runnable update = () -> {
            String newFilter = this.txtFilter.getText();
            this.setFilter(newFilter);
        };
        if (display.getThread() == Thread.currentThread()) {
            update.run();
        } else {
            display.asyncExec(update);
        }
    };
    private ScheduledFuture<?> scheduledFilterUpdate = null;

    public FilterPanelPart(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, 0, 0);
    }

    public Control createControl(Composite parent, int marginWidth, int marginHeight) {
        this.panel = new Composite(parent, 0);
        this.panel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtFilter = new Text(this.panel, 896);
        this.txtFilter.setMessage("Enter search string");
        if (this.filter != null) {
            this.txtFilter.setText(this.filter);
        }
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        this.panel.setLayout((Layout)layout);
        this.txtFilter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent ev) {
                try {
                    FilterPanelPart.this.scheduledFilterLock.lock();
                    if (FilterPanelPart.this.scheduledFilterUpdate != null) {
                        FilterPanelPart.this.scheduledFilterUpdate.cancel(true);
                    }
                }
                finally {
                    FilterPanelPart.this.scheduledFilterLock.unlock();
                }
                String newFilter = ev.detail == 256 ? "" : FilterPanelPart.this.txtFilter.getText();
                FilterPanelPart.this.setFilter(newFilter);
            }
        });
        this.txtFilter.addModifyListener(ev -> {
            try {
                this.scheduledFilterLock.lock();
                if (this.scheduledFilterUpdate != null) {
                    this.scheduledFilterUpdate.cancel(true);
                }
                this.scheduledFilterUpdate = this.scheduler.schedule(this.updateFilterTask, 300L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.scheduledFilterLock.unlock();
            }
        });
        return this.panel;
    }

    public Text getFilterControl() {
        return this.txtFilter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        String old = this.filter;
        this.filter = filter;
        this.propSupport.firePropertyChange(PROP_FILTER, old, filter);
    }

    public void setFocus() {
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            this.txtFilter.setFocus();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(PROP_FILTER, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(PROP_FILTER, listener);
    }

    public void setHint(String string) {
        this.getFilterControl().setMessage(string);
    }
}

